// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Configuration of the build.
 */
@Immutable
public final class ContainerAppsBuildConfiguration implements JsonSerializable<ContainerAppsBuildConfiguration> {
    /*
     * Base OS used to build and run the app.
     */
    private String baseOs;

    /*
     * Platform to be used to build and run the app.
     */
    private String platform;

    /*
     * Platform version to be used to build and run the app.
     */
    private String platformVersion;

    /*
     * List of environment variables to be passed to the build, secrets should not be used in environment variable.
     */
    private List<EnvironmentVariable> environmentVariables;

    /*
     * List of steps to perform before the build.
     */
    private List<PreBuildStep> preBuildSteps;

    /**
     * Creates an instance of ContainerAppsBuildConfiguration class.
     */
    public ContainerAppsBuildConfiguration() {
    }

    /**
     * Get the baseOs property: Base OS used to build and run the app.
     * 
     * @return the baseOs value.
     */
    public String baseOs() {
        return this.baseOs;
    }

    /**
     * Get the platform property: Platform to be used to build and run the app.
     * 
     * @return the platform value.
     */
    public String platform() {
        return this.platform;
    }

    /**
     * Get the platformVersion property: Platform version to be used to build and run the app.
     * 
     * @return the platformVersion value.
     */
    public String platformVersion() {
        return this.platformVersion;
    }

    /**
     * Get the environmentVariables property: List of environment variables to be passed to the build, secrets should
     * not be used in environment variable.
     * 
     * @return the environmentVariables value.
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Get the preBuildSteps property: List of steps to perform before the build.
     * 
     * @return the preBuildSteps value.
     */
    public List<PreBuildStep> preBuildSteps() {
        return this.preBuildSteps;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (environmentVariables() != null) {
            environmentVariables().forEach(e -> e.validate());
        }
        if (preBuildSteps() != null) {
            preBuildSteps().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerAppsBuildConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerAppsBuildConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerAppsBuildConfiguration.
     */
    public static ContainerAppsBuildConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppsBuildConfiguration deserializedContainerAppsBuildConfiguration
                = new ContainerAppsBuildConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("baseOs".equals(fieldName)) {
                    deserializedContainerAppsBuildConfiguration.baseOs = reader.getString();
                } else if ("platform".equals(fieldName)) {
                    deserializedContainerAppsBuildConfiguration.platform = reader.getString();
                } else if ("platformVersion".equals(fieldName)) {
                    deserializedContainerAppsBuildConfiguration.platformVersion = reader.getString();
                } else if ("environmentVariables".equals(fieldName)) {
                    List<EnvironmentVariable> environmentVariables
                        = reader.readArray(reader1 -> EnvironmentVariable.fromJson(reader1));
                    deserializedContainerAppsBuildConfiguration.environmentVariables = environmentVariables;
                } else if ("preBuildSteps".equals(fieldName)) {
                    List<PreBuildStep> preBuildSteps = reader.readArray(reader1 -> PreBuildStep.fromJson(reader1));
                    deserializedContainerAppsBuildConfiguration.preBuildSteps = preBuildSteps;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerAppsBuildConfiguration;
        });
    }
}
