// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppsBuildResourceInner;

/**
 * An immutable client-side representation of ContainerAppsBuildResource.
 */
public interface ContainerAppsBuildResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the provisioningState property: Build provisioning state.
     * 
     * @return the provisioningState value.
     */
    BuildProvisioningState provisioningState();

    /**
     * Gets the buildStatus property: Status of the build once it has been provisioned.
     * 
     * @return the buildStatus value.
     */
    BuildStatus buildStatus();

    /**
     * Gets the destinationContainerRegistry property: Container registry that the final image will be uploaded to.
     * 
     * @return the destinationContainerRegistry value.
     */
    ContainerRegistryWithCustomImage destinationContainerRegistry();

    /**
     * Gets the configuration property: Configuration of the build.
     * 
     * @return the configuration value.
     */
    ContainerAppsBuildConfiguration configuration();

    /**
     * Gets the logStreamEndpoint property: Endpoint from which the build logs can be streamed.
     * 
     * @return the logStreamEndpoint value.
     */
    String logStreamEndpoint();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.ContainerAppsBuildResourceInner object.
     * 
     * @return the inner object.
     */
    ContainerAppsBuildResourceInner innerModel();
}
