// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of ContainerAppsPatches.
 */
public interface ContainerAppsPatches {
    /**
     * List Container Apps Patch resources by ContainerApp.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App patch collection as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ContainerAppsPatchResource> listByContainerApp(String resourceGroupName, String containerAppName);

    /**
     * List Container Apps Patch resources by ContainerApp.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @param filter The filter to apply on the operation. For example, $filter=properties/patchApplyStatus eq
     * 'Succeeded'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App patch collection as paginated response with {@link PagedIterable}.
     */
    PagedIterable<ContainerAppsPatchResource> listByContainerApp(String resourceGroupName, String containerAppName,
        String filter, Context context);

    /**
     * Get details for specific Container Apps Patch by patch name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @param patchName The name of the patch.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details for specific Container Apps Patch by patch name along with {@link Response}.
     */
    Response<ContainerAppsPatchResource> getWithResponse(String resourceGroupName, String containerAppName,
        String patchName, Context context);

    /**
     * Get details for specific Container Apps Patch by patch name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @param patchName The name of the patch.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details for specific Container Apps Patch by patch name.
     */
    ContainerAppsPatchResource get(String resourceGroupName, String containerAppName, String patchName);

    /**
     * Delete specific Container Apps Patch by patch name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @param patchName The name of the patch.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String containerAppName, String patchName);

    /**
     * Delete specific Container Apps Patch by patch name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @param patchName The name of the patch.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String containerAppName, String patchName, Context context);

    /**
     * Configure the Container Apps Patch skip option by patch name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @param patchName The name of the patch.
     * @param patchSkipConfig Configure patcher to skip a patch or not.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void skipConfigure(String resourceGroupName, String containerAppName, String patchName,
        PatchSkipConfig patchSkipConfig);

    /**
     * Configure the Container Apps Patch skip option by patch name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @param patchName The name of the patch.
     * @param patchSkipConfig Configure patcher to skip a patch or not.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void skipConfigure(String resourceGroupName, String containerAppName, String patchName,
        PatchSkipConfig patchSkipConfig, Context context);

    /**
     * Apply a Container Apps Patch resource with patch name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @param patchName The name of the patch.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Patch.
     */
    ContainerAppsPatchResource apply(String resourceGroupName, String containerAppName, String patchName);

    /**
     * Apply a Container Apps Patch resource with patch name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param containerAppName Name of the Container App the Patch is associated.
     * @param patchName The name of the patch.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return container App Patch.
     */
    ContainerAppsPatchResource apply(String resourceGroupName, String containerAppName, String patchName,
        Context context);
}
