// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of ContainerAppsSessionPools.
 */
public interface ContainerAppsSessionPools {
    /**
     * Get the session pools in a given subscription.
     * 
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription as paginated response with {@link PagedIterable}.
     */
    PagedIterable<SessionPool> list();

    /**
     * Get the session pools in a given subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given subscription as paginated response with {@link PagedIterable}.
     */
    PagedIterable<SessionPool> list(Context context);

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<SessionPool> listByResourceGroup(String resourceGroupName);

    /**
     * Get the session pools in a given resource group of a subscription.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the session pools in a given resource group of a subscription as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<SessionPool> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Get the properties of a session pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool along with {@link Response}.
     */
    Response<SessionPool> getByResourceGroupWithResponse(String resourceGroupName, String sessionPoolName,
        Context context);

    /**
     * Get the properties of a session pool.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool.
     */
    SessionPool getByResourceGroup(String resourceGroupName, String sessionPoolName);

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByResourceGroup(String resourceGroupName, String sessionPoolName);

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sessionPoolName Name of the session pool.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String sessionPoolName, Context context);

    /**
     * Get the properties of a session pool.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool along with {@link Response}.
     */
    SessionPool getById(String id);

    /**
     * Get the properties of a session pool.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a session pool along with {@link Response}.
     */
    Response<SessionPool> getByIdWithResponse(String id, Context context);

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Delete a session pool.
     * 
     * Delete the session pool with the given name.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new SessionPool resource.
     * 
     * @param name resource name.
     * @return the first stage of the new SessionPool definition.
     */
    SessionPool.DefinitionStages.Blank define(String name);
}
