// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container Apps Job execution container status. Contains status code and reason.
 */
@Fluent
public final class ContainerExecutionStatus implements JsonSerializable<ContainerExecutionStatus> {
    /*
     * Container Name.
     */
    private String name;

    /*
     * Exit code
     */
    private Integer code;

    /*
     * Additional information for the container status
     */
    private String additionalInformation;

    /*
     * Status of the container
     */
    private String status;

    /**
     * Creates an instance of ContainerExecutionStatus class.
     */
    public ContainerExecutionStatus() {
    }

    /**
     * Get the name property: Container Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Container Name.
     * 
     * @param name the name value to set.
     * @return the ContainerExecutionStatus object itself.
     */
    public ContainerExecutionStatus withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the code property: Exit code.
     * 
     * @return the code value.
     */
    public Integer code() {
        return this.code;
    }

    /**
     * Set the code property: Exit code.
     * 
     * @param code the code value to set.
     * @return the ContainerExecutionStatus object itself.
     */
    public ContainerExecutionStatus withCode(Integer code) {
        this.code = code;
        return this;
    }

    /**
     * Get the additionalInformation property: Additional information for the container status.
     * 
     * @return the additionalInformation value.
     */
    public String additionalInformation() {
        return this.additionalInformation;
    }

    /**
     * Set the additionalInformation property: Additional information for the container status.
     * 
     * @param additionalInformation the additionalInformation value to set.
     * @return the ContainerExecutionStatus object itself.
     */
    public ContainerExecutionStatus withAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    /**
     * Get the status property: Status of the container.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: Status of the container.
     * 
     * @param status the status value to set.
     * @return the ContainerExecutionStatus object itself.
     */
    public ContainerExecutionStatus withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("code", this.code);
        jsonWriter.writeStringField("additionalInformation", this.additionalInformation);
        jsonWriter.writeStringField("status", this.status);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerExecutionStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerExecutionStatus if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerExecutionStatus.
     */
    public static ContainerExecutionStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerExecutionStatus deserializedContainerExecutionStatus = new ContainerExecutionStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedContainerExecutionStatus.name = reader.getString();
                } else if ("code".equals(fieldName)) {
                    deserializedContainerExecutionStatus.code = reader.getNullable(JsonReader::getInt);
                } else if ("additionalInformation".equals(fieldName)) {
                    deserializedContainerExecutionStatus.additionalInformation = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedContainerExecutionStatus.status = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerExecutionStatus;
        });
    }
}
