// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Model representing a mapping from a container registry to the identity used to connect to it.
 */
@Fluent
public final class ContainerRegistry implements JsonSerializable<ContainerRegistry> {
    /*
     * Login server of the container registry.
     */
    private String containerRegistryServer;

    /*
     * Resource ID of the managed identity.
     */
    private String identityResourceId;

    /**
     * Creates an instance of ContainerRegistry class.
     */
    public ContainerRegistry() {
    }

    /**
     * Get the containerRegistryServer property: Login server of the container registry.
     * 
     * @return the containerRegistryServer value.
     */
    public String containerRegistryServer() {
        return this.containerRegistryServer;
    }

    /**
     * Set the containerRegistryServer property: Login server of the container registry.
     * 
     * @param containerRegistryServer the containerRegistryServer value to set.
     * @return the ContainerRegistry object itself.
     */
    public ContainerRegistry withContainerRegistryServer(String containerRegistryServer) {
        this.containerRegistryServer = containerRegistryServer;
        return this;
    }

    /**
     * Get the identityResourceId property: Resource ID of the managed identity.
     * 
     * @return the identityResourceId value.
     */
    public String identityResourceId() {
        return this.identityResourceId;
    }

    /**
     * Set the identityResourceId property: Resource ID of the managed identity.
     * 
     * @param identityResourceId the identityResourceId value to set.
     * @return the ContainerRegistry object itself.
     */
    public ContainerRegistry withIdentityResourceId(String identityResourceId) {
        this.identityResourceId = identityResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (containerRegistryServer() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property containerRegistryServer in model ContainerRegistry"));
        }
        if (identityResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property identityResourceId in model ContainerRegistry"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistry.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerRegistryServer", this.containerRegistryServer);
        jsonWriter.writeStringField("identityResourceId", this.identityResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerRegistry from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerRegistry if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerRegistry.
     */
    public static ContainerRegistry fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerRegistry deserializedContainerRegistry = new ContainerRegistry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("containerRegistryServer".equals(fieldName)) {
                    deserializedContainerRegistry.containerRegistryServer = reader.getString();
                } else if ("identityResourceId".equals(fieldName)) {
                    deserializedContainerRegistry.identityResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerRegistry;
        });
    }
}
