// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container registry that the final image will be uploaded to.
 */
@Fluent
public final class ContainerRegistryWithCustomImage implements JsonSerializable<ContainerRegistryWithCustomImage> {
    /*
     * Login server of the container registry that the final image should be uploaded to. Builder resource needs to have
     * this container registry defined along with an identity to use to access it.
     */
    private String server;

    /*
     * Full name that the final image should be uploaded as, including both image name and tag.
     */
    private String image;

    /**
     * Creates an instance of ContainerRegistryWithCustomImage class.
     */
    public ContainerRegistryWithCustomImage() {
    }

    /**
     * Get the server property: Login server of the container registry that the final image should be uploaded to.
     * Builder resource needs to have this container registry defined along with an identity to use to access it.
     * 
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Set the server property: Login server of the container registry that the final image should be uploaded to.
     * Builder resource needs to have this container registry defined along with an identity to use to access it.
     * 
     * @param server the server value to set.
     * @return the ContainerRegistryWithCustomImage object itself.
     */
    public ContainerRegistryWithCustomImage withServer(String server) {
        this.server = server;
        return this;
    }

    /**
     * Get the image property: Full name that the final image should be uploaded as, including both image name and tag.
     * 
     * @return the image value.
     */
    public String image() {
        return this.image;
    }

    /**
     * Set the image property: Full name that the final image should be uploaded as, including both image name and tag.
     * 
     * @param image the image value to set.
     * @return the ContainerRegistryWithCustomImage object itself.
     */
    public ContainerRegistryWithCustomImage withImage(String image) {
        this.image = image;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (server() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property server in model ContainerRegistryWithCustomImage"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerRegistryWithCustomImage.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("image", this.image);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerRegistryWithCustomImage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerRegistryWithCustomImage if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerRegistryWithCustomImage.
     */
    public static ContainerRegistryWithCustomImage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerRegistryWithCustomImage deserializedContainerRegistryWithCustomImage
                = new ContainerRegistryWithCustomImage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("server".equals(fieldName)) {
                    deserializedContainerRegistryWithCustomImage.server = reader.getString();
                } else if ("image".equals(fieldName)) {
                    deserializedContainerRegistryWithCustomImage.image = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerRegistryWithCustomImage;
        });
    }
}
