// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container App container resource requirements.
 */
@Fluent
public final class ContainerResources implements JsonSerializable<ContainerResources> {
    /*
     * Required CPU in cores, e.g. 0.5
     */
    private Double cpu;

    /*
     * Required memory, e.g. "250Mb"
     */
    private String memory;

    /*
     * Ephemeral Storage, e.g. "1Gi"
     */
    private String ephemeralStorage;

    /**
     * Creates an instance of ContainerResources class.
     */
    public ContainerResources() {
    }

    /**
     * Get the cpu property: Required CPU in cores, e.g. 0.5.
     * 
     * @return the cpu value.
     */
    public Double cpu() {
        return this.cpu;
    }

    /**
     * Set the cpu property: Required CPU in cores, e.g. 0.5.
     * 
     * @param cpu the cpu value to set.
     * @return the ContainerResources object itself.
     */
    public ContainerResources withCpu(Double cpu) {
        this.cpu = cpu;
        return this;
    }

    /**
     * Get the memory property: Required memory, e.g. "250Mb".
     * 
     * @return the memory value.
     */
    public String memory() {
        return this.memory;
    }

    /**
     * Set the memory property: Required memory, e.g. "250Mb".
     * 
     * @param memory the memory value to set.
     * @return the ContainerResources object itself.
     */
    public ContainerResources withMemory(String memory) {
        this.memory = memory;
        return this;
    }

    /**
     * Get the ephemeralStorage property: Ephemeral Storage, e.g. "1Gi".
     * 
     * @return the ephemeralStorage value.
     */
    public String ephemeralStorage() {
        return this.ephemeralStorage;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("cpu", this.cpu);
        jsonWriter.writeStringField("memory", this.memory);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerResources from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerResources if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerResources.
     */
    public static ContainerResources fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerResources deserializedContainerResources = new ContainerResources();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cpu".equals(fieldName)) {
                    deserializedContainerResources.cpu = reader.getNullable(JsonReader::getDouble);
                } else if ("memory".equals(fieldName)) {
                    deserializedContainerResources.memory = reader.getString();
                } else if ("ephemeralStorage".equals(fieldName)) {
                    deserializedContainerResources.ephemeralStorage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerResources;
        });
    }
}
