// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The container type of the sessions.
 */
public final class ContainerType extends ExpandableStringEnum<ContainerType> {
    /**
     * Static value CustomContainer for ContainerType.
     */
    public static final ContainerType CUSTOM_CONTAINER = fromString("CustomContainer");

    /**
     * Static value PythonLTS for ContainerType.
     */
    public static final ContainerType PYTHON_LTS = fromString("PythonLTS");

    /**
     * Creates a new instance of ContainerType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ContainerType() {
    }

    /**
     * Creates or finds a ContainerType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ContainerType.
     */
    public static ContainerType fromString(String name) {
        return fromString(name, ContainerType.class);
    }

    /**
     * Gets known ContainerType values.
     * 
     * @return known ContainerType values.
     */
    public static Collection<ContainerType> values() {
        return values(ContainerType.class);
    }
}
