// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the session cookie's expiration.
 */
@Fluent
public final class CookieExpiration implements JsonSerializable<CookieExpiration> {
    /*
     * The convention used when determining the session cookie's expiration.
     */
    private CookieExpirationConvention convention;

    /*
     * The time after the request is made when the session cookie should expire.
     */
    private String timeToExpiration;

    /**
     * Creates an instance of CookieExpiration class.
     */
    public CookieExpiration() {
    }

    /**
     * Get the convention property: The convention used when determining the session cookie's expiration.
     * 
     * @return the convention value.
     */
    public CookieExpirationConvention convention() {
        return this.convention;
    }

    /**
     * Set the convention property: The convention used when determining the session cookie's expiration.
     * 
     * @param convention the convention value to set.
     * @return the CookieExpiration object itself.
     */
    public CookieExpiration withConvention(CookieExpirationConvention convention) {
        this.convention = convention;
        return this;
    }

    /**
     * Get the timeToExpiration property: The time after the request is made when the session cookie should expire.
     * 
     * @return the timeToExpiration value.
     */
    public String timeToExpiration() {
        return this.timeToExpiration;
    }

    /**
     * Set the timeToExpiration property: The time after the request is made when the session cookie should expire.
     * 
     * @param timeToExpiration the timeToExpiration value to set.
     * @return the CookieExpiration object itself.
     */
    public CookieExpiration withTimeToExpiration(String timeToExpiration) {
        this.timeToExpiration = timeToExpiration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("convention", this.convention == null ? null : this.convention.toString());
        jsonWriter.writeStringField("timeToExpiration", this.timeToExpiration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CookieExpiration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CookieExpiration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CookieExpiration.
     */
    public static CookieExpiration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CookieExpiration deserializedCookieExpiration = new CookieExpiration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("convention".equals(fieldName)) {
                    deserializedCookieExpiration.convention = CookieExpirationConvention.fromString(reader.getString());
                } else if ("timeToExpiration".equals(fieldName)) {
                    deserializedCookieExpiration.timeToExpiration = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCookieExpiration;
        });
    }
}
