// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Custom container configuration.
 */
@Fluent
public final class CustomContainerTemplate implements JsonSerializable<CustomContainerTemplate> {
    /*
     * Private container registry credentials for containers used by the sessions of the session pool.
     */
    private SessionRegistryCredentials registryCredentials;

    /*
     * List of container definitions for the sessions of the session pool.
     */
    private List<SessionContainer> containers;

    /*
     * Session pool ingress configuration.
     */
    private SessionIngress ingress;

    /**
     * Creates an instance of CustomContainerTemplate class.
     */
    public CustomContainerTemplate() {
    }

    /**
     * Get the registryCredentials property: Private container registry credentials for containers used by the sessions
     * of the session pool.
     * 
     * @return the registryCredentials value.
     */
    public SessionRegistryCredentials registryCredentials() {
        return this.registryCredentials;
    }

    /**
     * Set the registryCredentials property: Private container registry credentials for containers used by the sessions
     * of the session pool.
     * 
     * @param registryCredentials the registryCredentials value to set.
     * @return the CustomContainerTemplate object itself.
     */
    public CustomContainerTemplate withRegistryCredentials(SessionRegistryCredentials registryCredentials) {
        this.registryCredentials = registryCredentials;
        return this;
    }

    /**
     * Get the containers property: List of container definitions for the sessions of the session pool.
     * 
     * @return the containers value.
     */
    public List<SessionContainer> containers() {
        return this.containers;
    }

    /**
     * Set the containers property: List of container definitions for the sessions of the session pool.
     * 
     * @param containers the containers value to set.
     * @return the CustomContainerTemplate object itself.
     */
    public CustomContainerTemplate withContainers(List<SessionContainer> containers) {
        this.containers = containers;
        return this;
    }

    /**
     * Get the ingress property: Session pool ingress configuration.
     * 
     * @return the ingress value.
     */
    public SessionIngress ingress() {
        return this.ingress;
    }

    /**
     * Set the ingress property: Session pool ingress configuration.
     * 
     * @param ingress the ingress value to set.
     * @return the CustomContainerTemplate object itself.
     */
    public CustomContainerTemplate withIngress(SessionIngress ingress) {
        this.ingress = ingress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (registryCredentials() != null) {
            registryCredentials().validate();
        }
        if (containers() != null) {
            containers().forEach(e -> e.validate());
        }
        if (ingress() != null) {
            ingress().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("registryCredentials", this.registryCredentials);
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("ingress", this.ingress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomContainerTemplate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomContainerTemplate if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomContainerTemplate.
     */
    public static CustomContainerTemplate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomContainerTemplate deserializedCustomContainerTemplate = new CustomContainerTemplate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("registryCredentials".equals(fieldName)) {
                    deserializedCustomContainerTemplate.registryCredentials
                        = SessionRegistryCredentials.fromJson(reader);
                } else if ("containers".equals(fieldName)) {
                    List<SessionContainer> containers = reader.readArray(reader1 -> SessionContainer.fromJson(reader1));
                    deserializedCustomContainerTemplate.containers = containers;
                } else if ("ingress".equals(fieldName)) {
                    deserializedCustomContainerTemplate.ingress = SessionIngress.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomContainerTemplate;
        });
    }
}
