// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Custom Domain of a Container App.
 */
@Fluent
public final class CustomDomain implements JsonSerializable<CustomDomain> {
    /*
     * Hostname.
     */
    private String name;

    /*
     * Custom Domain binding type.
     */
    private BindingType bindingType;

    /*
     * Resource Id of the Certificate to be bound to this hostname. Must exist in the Managed Environment.
     */
    private String certificateId;

    /**
     * Creates an instance of CustomDomain class.
     */
    public CustomDomain() {
    }

    /**
     * Get the name property: Hostname.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Hostname.
     * 
     * @param name the name value to set.
     * @return the CustomDomain object itself.
     */
    public CustomDomain withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the bindingType property: Custom Domain binding type.
     * 
     * @return the bindingType value.
     */
    public BindingType bindingType() {
        return this.bindingType;
    }

    /**
     * Set the bindingType property: Custom Domain binding type.
     * 
     * @param bindingType the bindingType value to set.
     * @return the CustomDomain object itself.
     */
    public CustomDomain withBindingType(BindingType bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    /**
     * Get the certificateId property: Resource Id of the Certificate to be bound to this hostname. Must exist in the
     * Managed Environment.
     * 
     * @return the certificateId value.
     */
    public String certificateId() {
        return this.certificateId;
    }

    /**
     * Set the certificateId property: Resource Id of the Certificate to be bound to this hostname. Must exist in the
     * Managed Environment.
     * 
     * @param certificateId the certificateId value to set.
     * @return the CustomDomain object itself.
     */
    public CustomDomain withCertificateId(String certificateId) {
        this.certificateId = certificateId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model CustomDomain"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CustomDomain.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("bindingType", this.bindingType == null ? null : this.bindingType.toString());
        jsonWriter.writeStringField("certificateId", this.certificateId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomDomain from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomDomain if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomDomain.
     */
    public static CustomDomain fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomDomain deserializedCustomDomain = new CustomDomain();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCustomDomain.name = reader.getString();
                } else if ("bindingType".equals(fieldName)) {
                    deserializedCustomDomain.bindingType = BindingType.fromString(reader.getString());
                } else if ("certificateId".equals(fieldName)) {
                    deserializedCustomDomain.certificateId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomDomain;
        });
    }
}
