// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Detailed errors.
 */
@Immutable
public final class CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem
    implements JsonSerializable<CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem> {
    /*
     * Standardized string to programmatically identify the error.
     */
    private String code;

    /*
     * Detailed error description and debugging information.
     */
    private String message;

    /*
     * Detailed error description and debugging information.
     */
    private String target;

    /**
     * Creates an instance of CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem class.
     */
    public CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem() {
    }

    /**
     * Get the code property: Standardized string to programmatically identify the error.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the message property: Detailed error description and debugging information.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Get the target property: Detailed error description and debugging information.
     * 
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem from the
     * JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem if the
     * JsonReader was pointing to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem.
     */
    public static CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem
        fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem deserializedCustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem
                = new CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem.code
                        = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem.message
                        = reader.getString();
                } else if ("target".equals(fieldName)) {
                    deserializedCustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem.target
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem;
        });
    }
}
