// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentResiliencyPolicyInner;

/**
 * An immutable client-side representation of DaprComponentResiliencyPolicy.
 */
public interface DaprComponentResiliencyPolicy {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the inboundPolicy property: The optional inbound component resiliency policy configuration.
     * 
     * @return the inboundPolicy value.
     */
    DaprComponentResiliencyPolicyConfiguration inboundPolicy();

    /**
     * Gets the outboundPolicy property: The optional outbound component resiliency policy configuration.
     * 
     * @return the outboundPolicy value.
     */
    DaprComponentResiliencyPolicyConfiguration outboundPolicy();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentResiliencyPolicyInner object.
     * 
     * @return the inner object.
     */
    DaprComponentResiliencyPolicyInner innerModel();

    /**
     * The entirety of the DaprComponentResiliencyPolicy definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The DaprComponentResiliencyPolicy definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the DaprComponentResiliencyPolicy definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the DaprComponentResiliencyPolicy definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, environmentName, componentName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param environmentName Name of the Managed Environment.
             * @param componentName Name of the Dapr Component.
             * @return the next definition stage.
             */
            WithCreate withExistingDaprComponent(String resourceGroupName, String environmentName,
                String componentName);
        }

        /**
         * The stage of the DaprComponentResiliencyPolicy definition which contains all the minimum required properties
         * for the resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithInboundPolicy, DefinitionStages.WithOutboundPolicy {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            DaprComponentResiliencyPolicy create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            DaprComponentResiliencyPolicy create(Context context);
        }

        /**
         * The stage of the DaprComponentResiliencyPolicy definition allowing to specify inboundPolicy.
         */
        interface WithInboundPolicy {
            /**
             * Specifies the inboundPolicy property: The optional inbound component resiliency policy configuration.
             * 
             * @param inboundPolicy The optional inbound component resiliency policy configuration.
             * @return the next definition stage.
             */
            WithCreate withInboundPolicy(DaprComponentResiliencyPolicyConfiguration inboundPolicy);
        }

        /**
         * The stage of the DaprComponentResiliencyPolicy definition allowing to specify outboundPolicy.
         */
        interface WithOutboundPolicy {
            /**
             * Specifies the outboundPolicy property: The optional outbound component resiliency policy configuration.
             * 
             * @param outboundPolicy The optional outbound component resiliency policy configuration.
             * @return the next definition stage.
             */
            WithCreate withOutboundPolicy(DaprComponentResiliencyPolicyConfiguration outboundPolicy);
        }
    }

    /**
     * Begins update for the DaprComponentResiliencyPolicy resource.
     * 
     * @return the stage of resource update.
     */
    DaprComponentResiliencyPolicy.Update update();

    /**
     * The template for DaprComponentResiliencyPolicy update.
     */
    interface Update extends UpdateStages.WithInboundPolicy, UpdateStages.WithOutboundPolicy {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        DaprComponentResiliencyPolicy apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        DaprComponentResiliencyPolicy apply(Context context);
    }

    /**
     * The DaprComponentResiliencyPolicy update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the DaprComponentResiliencyPolicy update allowing to specify inboundPolicy.
         */
        interface WithInboundPolicy {
            /**
             * Specifies the inboundPolicy property: The optional inbound component resiliency policy configuration.
             * 
             * @param inboundPolicy The optional inbound component resiliency policy configuration.
             * @return the next definition stage.
             */
            Update withInboundPolicy(DaprComponentResiliencyPolicyConfiguration inboundPolicy);
        }

        /**
         * The stage of the DaprComponentResiliencyPolicy update allowing to specify outboundPolicy.
         */
        interface WithOutboundPolicy {
            /**
             * Specifies the outboundPolicy property: The optional outbound component resiliency policy configuration.
             * 
             * @param outboundPolicy The optional outbound component resiliency policy configuration.
             * @return the next definition stage.
             */
            Update withOutboundPolicy(DaprComponentResiliencyPolicyConfiguration outboundPolicy);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    DaprComponentResiliencyPolicy refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    DaprComponentResiliencyPolicy refresh(Context context);
}
