// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Dapr Component Resiliency Policy Circuit Breaker Policy Configuration.
 */
@Fluent
public final class DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration
    implements JsonSerializable<DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration> {
    /*
     * The number of consecutive errors before the circuit is opened.
     */
    private Integer consecutiveErrors;

    /*
     * The interval in seconds until a retry attempt is made after the circuit is opened.
     */
    private Integer timeoutInSeconds;

    /*
     * The optional interval in seconds after which the error count resets to 0. An interval of 0 will never reset. If
     * not specified, the timeoutInSeconds value will be used.
     */
    private Integer intervalInSeconds;

    /**
     * Creates an instance of DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration class.
     */
    public DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration() {
    }

    /**
     * Get the consecutiveErrors property: The number of consecutive errors before the circuit is opened.
     * 
     * @return the consecutiveErrors value.
     */
    public Integer consecutiveErrors() {
        return this.consecutiveErrors;
    }

    /**
     * Set the consecutiveErrors property: The number of consecutive errors before the circuit is opened.
     * 
     * @param consecutiveErrors the consecutiveErrors value to set.
     * @return the DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration object itself.
     */
    public DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration
        withConsecutiveErrors(Integer consecutiveErrors) {
        this.consecutiveErrors = consecutiveErrors;
        return this;
    }

    /**
     * Get the timeoutInSeconds property: The interval in seconds until a retry attempt is made after the circuit is
     * opened.
     * 
     * @return the timeoutInSeconds value.
     */
    public Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    /**
     * Set the timeoutInSeconds property: The interval in seconds until a retry attempt is made after the circuit is
     * opened.
     * 
     * @param timeoutInSeconds the timeoutInSeconds value to set.
     * @return the DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration object itself.
     */
    public DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration
        withTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        return this;
    }

    /**
     * Get the intervalInSeconds property: The optional interval in seconds after which the error count resets to 0. An
     * interval of 0 will never reset. If not specified, the timeoutInSeconds value will be used.
     * 
     * @return the intervalInSeconds value.
     */
    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    /**
     * Set the intervalInSeconds property: The optional interval in seconds after which the error count resets to 0. An
     * interval of 0 will never reset. If not specified, the timeoutInSeconds value will be used.
     * 
     * @param intervalInSeconds the intervalInSeconds value to set.
     * @return the DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration object itself.
     */
    public DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration
        withIntervalInSeconds(Integer intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("consecutiveErrors", this.consecutiveErrors);
        jsonWriter.writeNumberField("timeoutInSeconds", this.timeoutInSeconds);
        jsonWriter.writeNumberField("intervalInSeconds", this.intervalInSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration if the JsonReader was
     * pointing to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration.
     */
    public static DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration deserializedDaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration
                = new DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("consecutiveErrors".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration.consecutiveErrors
                        = reader.getNullable(JsonReader::getInt);
                } else if ("timeoutInSeconds".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration.timeoutInSeconds
                        = reader.getNullable(JsonReader::getInt);
                } else if ("intervalInSeconds".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration.intervalInSeconds
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration;
        });
    }
}
