// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Dapr Component Resiliency Policy HTTP Retry Backoff Configuration.
 */
@Fluent
public final class DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration
    implements JsonSerializable<DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration> {
    /*
     * The optional initial delay in milliseconds before an operation is retried
     */
    private Integer initialDelayInMilliseconds;

    /*
     * The optional maximum time interval in milliseconds between retry attempts
     */
    private Integer maxIntervalInMilliseconds;

    /**
     * Creates an instance of DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration class.
     */
    public DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration() {
    }

    /**
     * Get the initialDelayInMilliseconds property: The optional initial delay in milliseconds before an operation is
     * retried.
     * 
     * @return the initialDelayInMilliseconds value.
     */
    public Integer initialDelayInMilliseconds() {
        return this.initialDelayInMilliseconds;
    }

    /**
     * Set the initialDelayInMilliseconds property: The optional initial delay in milliseconds before an operation is
     * retried.
     * 
     * @param initialDelayInMilliseconds the initialDelayInMilliseconds value to set.
     * @return the DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration object itself.
     */
    public DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration
        withInitialDelayInMilliseconds(Integer initialDelayInMilliseconds) {
        this.initialDelayInMilliseconds = initialDelayInMilliseconds;
        return this;
    }

    /**
     * Get the maxIntervalInMilliseconds property: The optional maximum time interval in milliseconds between retry
     * attempts.
     * 
     * @return the maxIntervalInMilliseconds value.
     */
    public Integer maxIntervalInMilliseconds() {
        return this.maxIntervalInMilliseconds;
    }

    /**
     * Set the maxIntervalInMilliseconds property: The optional maximum time interval in milliseconds between retry
     * attempts.
     * 
     * @param maxIntervalInMilliseconds the maxIntervalInMilliseconds value to set.
     * @return the DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration object itself.
     */
    public DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration
        withMaxIntervalInMilliseconds(Integer maxIntervalInMilliseconds) {
        this.maxIntervalInMilliseconds = maxIntervalInMilliseconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("initialDelayInMilliseconds", this.initialDelayInMilliseconds);
        jsonWriter.writeNumberField("maxIntervalInMilliseconds", this.maxIntervalInMilliseconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration.
     */
    public static DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration deserializedDaprComponentResiliencyPolicyHttpRetryBackOffConfiguration
                = new DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("initialDelayInMilliseconds".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyHttpRetryBackOffConfiguration.initialDelayInMilliseconds
                        = reader.getNullable(JsonReader::getInt);
                } else if ("maxIntervalInMilliseconds".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyHttpRetryBackOffConfiguration.maxIntervalInMilliseconds
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprComponentResiliencyPolicyHttpRetryBackOffConfiguration;
        });
    }
}
