// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Dapr Component Resiliency Policy HTTP Retry Policy Configuration.
 */
@Fluent
public final class DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration
    implements JsonSerializable<DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration> {
    /*
     * The optional maximum number of retries
     */
    private Integer maxRetries;

    /*
     * The optional retry backoff configuration
     */
    private DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration retryBackOff;

    /**
     * Creates an instance of DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration class.
     */
    public DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration() {
    }

    /**
     * Get the maxRetries property: The optional maximum number of retries.
     * 
     * @return the maxRetries value.
     */
    public Integer maxRetries() {
        return this.maxRetries;
    }

    /**
     * Set the maxRetries property: The optional maximum number of retries.
     * 
     * @param maxRetries the maxRetries value to set.
     * @return the DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration object itself.
     */
    public DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration withMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    /**
     * Get the retryBackOff property: The optional retry backoff configuration.
     * 
     * @return the retryBackOff value.
     */
    public DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration retryBackOff() {
        return this.retryBackOff;
    }

    /**
     * Set the retryBackOff property: The optional retry backoff configuration.
     * 
     * @param retryBackOff the retryBackOff value to set.
     * @return the DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration object itself.
     */
    public DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration
        withRetryBackOff(DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration retryBackOff) {
        this.retryBackOff = retryBackOff;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (retryBackOff() != null) {
            retryBackOff().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxRetries", this.maxRetries);
        jsonWriter.writeJsonField("retryBackOff", this.retryBackOff);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration.
     */
    public static DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration deserializedDaprComponentResiliencyPolicyHttpRetryPolicyConfiguration
                = new DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxRetries".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyHttpRetryPolicyConfiguration.maxRetries
                        = reader.getNullable(JsonReader::getInt);
                } else if ("retryBackOff".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyHttpRetryPolicyConfiguration.retryBackOff
                        = DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprComponentResiliencyPolicyHttpRetryPolicyConfiguration;
        });
    }
}
