// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Dapr Component Resiliency Policy Timeout Policy Configuration.
 */
@Fluent
public final class DaprComponentResiliencyPolicyTimeoutPolicyConfiguration
    implements JsonSerializable<DaprComponentResiliencyPolicyTimeoutPolicyConfiguration> {
    /*
     * The optional response timeout in seconds
     */
    private Integer responseTimeoutInSeconds;

    /**
     * Creates an instance of DaprComponentResiliencyPolicyTimeoutPolicyConfiguration class.
     */
    public DaprComponentResiliencyPolicyTimeoutPolicyConfiguration() {
    }

    /**
     * Get the responseTimeoutInSeconds property: The optional response timeout in seconds.
     * 
     * @return the responseTimeoutInSeconds value.
     */
    public Integer responseTimeoutInSeconds() {
        return this.responseTimeoutInSeconds;
    }

    /**
     * Set the responseTimeoutInSeconds property: The optional response timeout in seconds.
     * 
     * @param responseTimeoutInSeconds the responseTimeoutInSeconds value to set.
     * @return the DaprComponentResiliencyPolicyTimeoutPolicyConfiguration object itself.
     */
    public DaprComponentResiliencyPolicyTimeoutPolicyConfiguration
        withResponseTimeoutInSeconds(Integer responseTimeoutInSeconds) {
        this.responseTimeoutInSeconds = responseTimeoutInSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("responseTimeoutInSeconds", this.responseTimeoutInSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprComponentResiliencyPolicyTimeoutPolicyConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprComponentResiliencyPolicyTimeoutPolicyConfiguration if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DaprComponentResiliencyPolicyTimeoutPolicyConfiguration.
     */
    public static DaprComponentResiliencyPolicyTimeoutPolicyConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            DaprComponentResiliencyPolicyTimeoutPolicyConfiguration deserializedDaprComponentResiliencyPolicyTimeoutPolicyConfiguration
                = new DaprComponentResiliencyPolicyTimeoutPolicyConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("responseTimeoutInSeconds".equals(fieldName)) {
                    deserializedDaprComponentResiliencyPolicyTimeoutPolicyConfiguration.responseTimeoutInSeconds
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprComponentResiliencyPolicyTimeoutPolicyConfiguration;
        });
    }
}
