// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;

/**
 * Resource collection API of DaprComponents.
 */
public interface DaprComponents {
    /**
     * Get the Dapr Components for a managed environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Dapr Components for a managed environment as paginated response with {@link PagedIterable}.
     */
    PagedIterable<DaprComponent> list(String resourceGroupName, String environmentName);

    /**
     * Get the Dapr Components for a managed environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Dapr Components for a managed environment as paginated response with {@link PagedIterable}.
     */
    PagedIterable<DaprComponent> list(String resourceGroupName, String environmentName, Context context);

    /**
     * Get a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a dapr component along with {@link Response}.
     */
    Response<DaprComponent> getWithResponse(String resourceGroupName, String environmentName, String componentName,
        Context context);

    /**
     * Get a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a dapr component.
     */
    DaprComponent get(String resourceGroupName, String environmentName, String componentName);

    /**
     * Creates or updates a Dapr Component.
     * 
     * Creates or updates a Dapr Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param daprComponentEnvelope Configuration details of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Component along with {@link Response}.
     */
    Response<DaprComponent> createOrUpdateWithResponse(String resourceGroupName, String environmentName,
        String componentName, DaprComponentInner daprComponentEnvelope, Context context);

    /**
     * Creates or updates a Dapr Component.
     * 
     * Creates or updates a Dapr Component in a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param daprComponentEnvelope Configuration details of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr Component.
     */
    DaprComponent createOrUpdate(String resourceGroupName, String environmentName, String componentName,
        DaprComponentInner daprComponentEnvelope);

    /**
     * Delete a Dapr Component.
     * 
     * Delete a Dapr Component from a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> deleteWithResponse(String resourceGroupName, String environmentName, String componentName,
        Context context);

    /**
     * Delete a Dapr Component.
     * 
     * Delete a Dapr Component from a Managed Environment.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String environmentName, String componentName);

    /**
     * List secrets for a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr component Secrets Collection for ListSecrets Action along with {@link Response}.
     */
    Response<DaprSecretsCollection> listSecretsWithResponse(String resourceGroupName, String environmentName,
        String componentName, Context context);

    /**
     * List secrets for a dapr component.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param environmentName Name of the Managed Environment.
     * @param componentName Name of the Dapr Component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException thrown if the request
     * is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dapr component Secrets Collection for ListSecrets Action.
     */
    DaprSecretsCollection listSecrets(String resourceGroupName, String environmentName, String componentName);
}
