// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Dapr component Secret for ListSecrets Action.
 */
@Immutable
public final class DaprSecret implements JsonSerializable<DaprSecret> {
    /*
     * Secret Name.
     */
    private String name;

    /*
     * Secret Value.
     */
    private String value;

    /**
     * Creates an instance of DaprSecret class.
     */
    public DaprSecret() {
    }

    /**
     * Get the name property: Secret Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the value property: Secret Value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprSecret from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprSecret if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the DaprSecret.
     */
    public static DaprSecret fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprSecret deserializedDaprSecret = new DaprSecret();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDaprSecret.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedDaprSecret.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprSecret;
        });
    }
}
