// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Dapr component metadata.
 */
@Fluent
public final class DaprServiceBindMetadata implements JsonSerializable<DaprServiceBindMetadata> {
    /*
     * Service bind metadata property name.
     */
    private String name;

    /*
     * Service bind metadata property value.
     */
    private String value;

    /**
     * Creates an instance of DaprServiceBindMetadata class.
     */
    public DaprServiceBindMetadata() {
    }

    /**
     * Get the name property: Service bind metadata property name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Service bind metadata property name.
     * 
     * @param name the name value to set.
     * @return the DaprServiceBindMetadata object itself.
     */
    public DaprServiceBindMetadata withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Service bind metadata property value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Service bind metadata property value.
     * 
     * @param value the value value to set.
     * @return the DaprServiceBindMetadata object itself.
     */
    public DaprServiceBindMetadata withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprServiceBindMetadata from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprServiceBindMetadata if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DaprServiceBindMetadata.
     */
    public static DaprServiceBindMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprServiceBindMetadata deserializedDaprServiceBindMetadata = new DaprServiceBindMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDaprServiceBindMetadata.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedDaprServiceBindMetadata.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprServiceBindMetadata;
        });
    }
}
