// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprSubscriptionInner;
import java.util.List;
import java.util.Map;

/**
 * An immutable client-side representation of DaprSubscription.
 */
public interface DaprSubscription {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the pubsubName property: Dapr PubSub component name.
     * 
     * @return the pubsubName value.
     */
    String pubsubName();

    /**
     * Gets the topic property: Topic name.
     * 
     * @return the topic value.
     */
    String topic();

    /**
     * Gets the deadLetterTopic property: Deadletter topic name.
     * 
     * @return the deadLetterTopic value.
     */
    String deadLetterTopic();

    /**
     * Gets the routes property: Subscription routes.
     * 
     * @return the routes value.
     */
    DaprSubscriptionRoutes routes();

    /**
     * Gets the scopes property: Application scopes to restrict the subscription to specific apps.
     * 
     * @return the scopes value.
     */
    List<String> scopes();

    /**
     * Gets the metadata property: Subscription metadata.
     * 
     * @return the metadata value.
     */
    Map<String, String> metadata();

    /**
     * Gets the bulkSubscribe property: Bulk subscription options.
     * 
     * @return the bulkSubscribe value.
     */
    DaprSubscriptionBulkSubscribeOptions bulkSubscribe();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.DaprSubscriptionInner object.
     * 
     * @return the inner object.
     */
    DaprSubscriptionInner innerModel();

    /**
     * The entirety of the DaprSubscription definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The DaprSubscription definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the DaprSubscription definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the DaprSubscription definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, environmentName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param environmentName Name of the Managed Environment.
             * @return the next definition stage.
             */
            WithCreate withExistingManagedEnvironment(String resourceGroupName, String environmentName);
        }

        /**
         * The stage of the DaprSubscription definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithPubsubName, DefinitionStages.WithTopic,
            DefinitionStages.WithDeadLetterTopic, DefinitionStages.WithRoutes, DefinitionStages.WithScopes,
            DefinitionStages.WithMetadata, DefinitionStages.WithBulkSubscribe {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            DaprSubscription create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            DaprSubscription create(Context context);
        }

        /**
         * The stage of the DaprSubscription definition allowing to specify pubsubName.
         */
        interface WithPubsubName {
            /**
             * Specifies the pubsubName property: Dapr PubSub component name.
             * 
             * @param pubsubName Dapr PubSub component name.
             * @return the next definition stage.
             */
            WithCreate withPubsubName(String pubsubName);
        }

        /**
         * The stage of the DaprSubscription definition allowing to specify topic.
         */
        interface WithTopic {
            /**
             * Specifies the topic property: Topic name.
             * 
             * @param topic Topic name.
             * @return the next definition stage.
             */
            WithCreate withTopic(String topic);
        }

        /**
         * The stage of the DaprSubscription definition allowing to specify deadLetterTopic.
         */
        interface WithDeadLetterTopic {
            /**
             * Specifies the deadLetterTopic property: Deadletter topic name.
             * 
             * @param deadLetterTopic Deadletter topic name.
             * @return the next definition stage.
             */
            WithCreate withDeadLetterTopic(String deadLetterTopic);
        }

        /**
         * The stage of the DaprSubscription definition allowing to specify routes.
         */
        interface WithRoutes {
            /**
             * Specifies the routes property: Subscription routes.
             * 
             * @param routes Subscription routes.
             * @return the next definition stage.
             */
            WithCreate withRoutes(DaprSubscriptionRoutes routes);
        }

        /**
         * The stage of the DaprSubscription definition allowing to specify scopes.
         */
        interface WithScopes {
            /**
             * Specifies the scopes property: Application scopes to restrict the subscription to specific apps..
             * 
             * @param scopes Application scopes to restrict the subscription to specific apps.
             * @return the next definition stage.
             */
            WithCreate withScopes(List<String> scopes);
        }

        /**
         * The stage of the DaprSubscription definition allowing to specify metadata.
         */
        interface WithMetadata {
            /**
             * Specifies the metadata property: Subscription metadata.
             * 
             * @param metadata Subscription metadata.
             * @return the next definition stage.
             */
            WithCreate withMetadata(Map<String, String> metadata);
        }

        /**
         * The stage of the DaprSubscription definition allowing to specify bulkSubscribe.
         */
        interface WithBulkSubscribe {
            /**
             * Specifies the bulkSubscribe property: Bulk subscription options.
             * 
             * @param bulkSubscribe Bulk subscription options.
             * @return the next definition stage.
             */
            WithCreate withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions bulkSubscribe);
        }
    }

    /**
     * Begins update for the DaprSubscription resource.
     * 
     * @return the stage of resource update.
     */
    DaprSubscription.Update update();

    /**
     * The template for DaprSubscription update.
     */
    interface Update extends UpdateStages.WithPubsubName, UpdateStages.WithTopic, UpdateStages.WithDeadLetterTopic,
        UpdateStages.WithRoutes, UpdateStages.WithScopes, UpdateStages.WithMetadata, UpdateStages.WithBulkSubscribe {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        DaprSubscription apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        DaprSubscription apply(Context context);
    }

    /**
     * The DaprSubscription update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the DaprSubscription update allowing to specify pubsubName.
         */
        interface WithPubsubName {
            /**
             * Specifies the pubsubName property: Dapr PubSub component name.
             * 
             * @param pubsubName Dapr PubSub component name.
             * @return the next definition stage.
             */
            Update withPubsubName(String pubsubName);
        }

        /**
         * The stage of the DaprSubscription update allowing to specify topic.
         */
        interface WithTopic {
            /**
             * Specifies the topic property: Topic name.
             * 
             * @param topic Topic name.
             * @return the next definition stage.
             */
            Update withTopic(String topic);
        }

        /**
         * The stage of the DaprSubscription update allowing to specify deadLetterTopic.
         */
        interface WithDeadLetterTopic {
            /**
             * Specifies the deadLetterTopic property: Deadletter topic name.
             * 
             * @param deadLetterTopic Deadletter topic name.
             * @return the next definition stage.
             */
            Update withDeadLetterTopic(String deadLetterTopic);
        }

        /**
         * The stage of the DaprSubscription update allowing to specify routes.
         */
        interface WithRoutes {
            /**
             * Specifies the routes property: Subscription routes.
             * 
             * @param routes Subscription routes.
             * @return the next definition stage.
             */
            Update withRoutes(DaprSubscriptionRoutes routes);
        }

        /**
         * The stage of the DaprSubscription update allowing to specify scopes.
         */
        interface WithScopes {
            /**
             * Specifies the scopes property: Application scopes to restrict the subscription to specific apps..
             * 
             * @param scopes Application scopes to restrict the subscription to specific apps.
             * @return the next definition stage.
             */
            Update withScopes(List<String> scopes);
        }

        /**
         * The stage of the DaprSubscription update allowing to specify metadata.
         */
        interface WithMetadata {
            /**
             * Specifies the metadata property: Subscription metadata.
             * 
             * @param metadata Subscription metadata.
             * @return the next definition stage.
             */
            Update withMetadata(Map<String, String> metadata);
        }

        /**
         * The stage of the DaprSubscription update allowing to specify bulkSubscribe.
         */
        interface WithBulkSubscribe {
            /**
             * Specifies the bulkSubscribe property: Bulk subscription options.
             * 
             * @param bulkSubscribe Bulk subscription options.
             * @return the next definition stage.
             */
            Update withBulkSubscribe(DaprSubscriptionBulkSubscribeOptions bulkSubscribe);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    DaprSubscription refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    DaprSubscription refresh(Context context);
}
