// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Dapr PubSub Event Subscription Routes configuration.
 */
@Fluent
public final class DaprSubscriptionRoutes implements JsonSerializable<DaprSubscriptionRoutes> {
    /*
     * The list of Dapr PubSub Event Subscription Route Rules.
     */
    private List<DaprSubscriptionRouteRule> rules;

    /*
     * The default path to deliver events that do not match any of the rules.
     */
    private String defaultProperty;

    /**
     * Creates an instance of DaprSubscriptionRoutes class.
     */
    public DaprSubscriptionRoutes() {
    }

    /**
     * Get the rules property: The list of Dapr PubSub Event Subscription Route Rules.
     * 
     * @return the rules value.
     */
    public List<DaprSubscriptionRouteRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: The list of Dapr PubSub Event Subscription Route Rules.
     * 
     * @param rules the rules value to set.
     * @return the DaprSubscriptionRoutes object itself.
     */
    public DaprSubscriptionRoutes withRules(List<DaprSubscriptionRouteRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Get the defaultProperty property: The default path to deliver events that do not match any of the rules.
     * 
     * @return the defaultProperty value.
     */
    public String defaultProperty() {
        return this.defaultProperty;
    }

    /**
     * Set the defaultProperty property: The default path to deliver events that do not match any of the rules.
     * 
     * @param defaultProperty the defaultProperty value to set.
     * @return the DaprSubscriptionRoutes object itself.
     */
    public DaprSubscriptionRoutes withDefaultProperty(String defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("default", this.defaultProperty);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DaprSubscriptionRoutes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DaprSubscriptionRoutes if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DaprSubscriptionRoutes.
     */
    public static DaprSubscriptionRoutes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DaprSubscriptionRoutes deserializedDaprSubscriptionRoutes = new DaprSubscriptionRoutes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("rules".equals(fieldName)) {
                    List<DaprSubscriptionRouteRule> rules
                        = reader.readArray(reader1 -> DaprSubscriptionRouteRule.fromJson(reader1));
                    deserializedDaprSubscriptionRoutes.rules = rules;
                } else if ("default".equals(fieldName)) {
                    deserializedDaprSubscriptionRoutes.defaultProperty = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDaprSubscriptionRoutes;
        });
    }
}
