// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration of datadog.
 */
@Fluent
public final class DataDogConfiguration implements JsonSerializable<DataDogConfiguration> {
    /*
     * The data dog site
     */
    private String site;

    /*
     * The data dog api key
     */
    private String key;

    /**
     * Creates an instance of DataDogConfiguration class.
     */
    public DataDogConfiguration() {
    }

    /**
     * Get the site property: The data dog site.
     * 
     * @return the site value.
     */
    public String site() {
        return this.site;
    }

    /**
     * Set the site property: The data dog site.
     * 
     * @param site the site value to set.
     * @return the DataDogConfiguration object itself.
     */
    public DataDogConfiguration withSite(String site) {
        this.site = site;
        return this;
    }

    /**
     * Get the key property: The data dog api key.
     * 
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Set the key property: The data dog api key.
     * 
     * @param key the key value to set.
     * @return the DataDogConfiguration object itself.
     */
    public DataDogConfiguration withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("site", this.site);
        jsonWriter.writeStringField("key", this.key);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataDogConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataDogConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataDogConfiguration.
     */
    public static DataDogConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataDogConfiguration deserializedDataDogConfiguration = new DataDogConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("site".equals(fieldName)) {
                    deserializedDataDogConfiguration.site = reader.getString();
                } else if ("key".equals(fieldName)) {
                    deserializedDataDogConfiguration.key = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataDogConfiguration;
        });
    }
}
