// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Configuration of Open Telemetry destinations.
 */
@Fluent
public final class DestinationsConfiguration implements JsonSerializable<DestinationsConfiguration> {
    /*
     * Open telemetry datadog destination configuration
     */
    private DataDogConfiguration dataDogConfiguration;

    /*
     * Open telemetry otlp configurations
     */
    private List<OtlpConfiguration> otlpConfigurations;

    /**
     * Creates an instance of DestinationsConfiguration class.
     */
    public DestinationsConfiguration() {
    }

    /**
     * Get the dataDogConfiguration property: Open telemetry datadog destination configuration.
     * 
     * @return the dataDogConfiguration value.
     */
    public DataDogConfiguration dataDogConfiguration() {
        return this.dataDogConfiguration;
    }

    /**
     * Set the dataDogConfiguration property: Open telemetry datadog destination configuration.
     * 
     * @param dataDogConfiguration the dataDogConfiguration value to set.
     * @return the DestinationsConfiguration object itself.
     */
    public DestinationsConfiguration withDataDogConfiguration(DataDogConfiguration dataDogConfiguration) {
        this.dataDogConfiguration = dataDogConfiguration;
        return this;
    }

    /**
     * Get the otlpConfigurations property: Open telemetry otlp configurations.
     * 
     * @return the otlpConfigurations value.
     */
    public List<OtlpConfiguration> otlpConfigurations() {
        return this.otlpConfigurations;
    }

    /**
     * Set the otlpConfigurations property: Open telemetry otlp configurations.
     * 
     * @param otlpConfigurations the otlpConfigurations value to set.
     * @return the DestinationsConfiguration object itself.
     */
    public DestinationsConfiguration withOtlpConfigurations(List<OtlpConfiguration> otlpConfigurations) {
        this.otlpConfigurations = otlpConfigurations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dataDogConfiguration() != null) {
            dataDogConfiguration().validate();
        }
        if (otlpConfigurations() != null) {
            otlpConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataDogConfiguration", this.dataDogConfiguration);
        jsonWriter.writeArrayField("otlpConfigurations", this.otlpConfigurations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DestinationsConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DestinationsConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DestinationsConfiguration.
     */
    public static DestinationsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DestinationsConfiguration deserializedDestinationsConfiguration = new DestinationsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dataDogConfiguration".equals(fieldName)) {
                    deserializedDestinationsConfiguration.dataDogConfiguration = DataDogConfiguration.fromJson(reader);
                } else if ("otlpConfigurations".equals(fieldName)) {
                    List<OtlpConfiguration> otlpConfigurations
                        = reader.readArray(reader1 -> OtlpConfiguration.fromJson(reader1));
                    deserializedDestinationsConfiguration.otlpConfigurations = otlpConfigurations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDestinationsConfiguration;
        });
    }
}
