// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Details of a diagnostics data provider.
 */
@Fluent
public final class DiagnosticDataProviderMetadata implements JsonSerializable<DiagnosticDataProviderMetadata> {
    /*
     * Name of data provider
     */
    private String providerName;

    /*
     * Collection of properties
     */
    private List<DiagnosticDataProviderMetadataPropertyBagItem> propertyBag;

    /**
     * Creates an instance of DiagnosticDataProviderMetadata class.
     */
    public DiagnosticDataProviderMetadata() {
    }

    /**
     * Get the providerName property: Name of data provider.
     * 
     * @return the providerName value.
     */
    public String providerName() {
        return this.providerName;
    }

    /**
     * Set the providerName property: Name of data provider.
     * 
     * @param providerName the providerName value to set.
     * @return the DiagnosticDataProviderMetadata object itself.
     */
    public DiagnosticDataProviderMetadata withProviderName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    /**
     * Get the propertyBag property: Collection of properties.
     * 
     * @return the propertyBag value.
     */
    public List<DiagnosticDataProviderMetadataPropertyBagItem> propertyBag() {
        return this.propertyBag;
    }

    /**
     * Set the propertyBag property: Collection of properties.
     * 
     * @param propertyBag the propertyBag value to set.
     * @return the DiagnosticDataProviderMetadata object itself.
     */
    public DiagnosticDataProviderMetadata
        withPropertyBag(List<DiagnosticDataProviderMetadataPropertyBagItem> propertyBag) {
        this.propertyBag = propertyBag;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (propertyBag() != null) {
            propertyBag().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("providerName", this.providerName);
        jsonWriter.writeArrayField("propertyBag", this.propertyBag, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticDataProviderMetadata from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticDataProviderMetadata if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticDataProviderMetadata.
     */
    public static DiagnosticDataProviderMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticDataProviderMetadata deserializedDiagnosticDataProviderMetadata
                = new DiagnosticDataProviderMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("providerName".equals(fieldName)) {
                    deserializedDiagnosticDataProviderMetadata.providerName = reader.getString();
                } else if ("propertyBag".equals(fieldName)) {
                    List<DiagnosticDataProviderMetadataPropertyBagItem> propertyBag
                        = reader.readArray(reader1 -> DiagnosticDataProviderMetadataPropertyBagItem.fromJson(reader1));
                    deserializedDiagnosticDataProviderMetadata.propertyBag = propertyBag;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticDataProviderMetadata;
        });
    }
}
