// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Property details.
 */
@Fluent
public final class DiagnosticDataProviderMetadataPropertyBagItem
    implements JsonSerializable<DiagnosticDataProviderMetadataPropertyBagItem> {
    /*
     * Property name
     */
    private String name;

    /*
     * Property value
     */
    private String value;

    /**
     * Creates an instance of DiagnosticDataProviderMetadataPropertyBagItem class.
     */
    public DiagnosticDataProviderMetadataPropertyBagItem() {
    }

    /**
     * Get the name property: Property name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Property name.
     * 
     * @param name the name value to set.
     * @return the DiagnosticDataProviderMetadataPropertyBagItem object itself.
     */
    public DiagnosticDataProviderMetadataPropertyBagItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Property value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Property value.
     * 
     * @param value the value value to set.
     * @return the DiagnosticDataProviderMetadataPropertyBagItem object itself.
     */
    public DiagnosticDataProviderMetadataPropertyBagItem withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticDataProviderMetadataPropertyBagItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticDataProviderMetadataPropertyBagItem if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticDataProviderMetadataPropertyBagItem.
     */
    public static DiagnosticDataProviderMetadataPropertyBagItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticDataProviderMetadataPropertyBagItem deserializedDiagnosticDataProviderMetadataPropertyBagItem
                = new DiagnosticDataProviderMetadataPropertyBagItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDiagnosticDataProviderMetadataPropertyBagItem.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedDiagnosticDataProviderMetadataPropertyBagItem.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticDataProviderMetadataPropertyBagItem;
        });
    }
}
