// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Diagnostics data table.
 */
@Fluent
public final class DiagnosticDataTableResponseObject implements JsonSerializable<DiagnosticDataTableResponseObject> {
    /*
     * Table name
     */
    private String tableName;

    /*
     * Columns in the table
     */
    private List<DiagnosticDataTableResponseColumn> columns;

    /*
     * Rows in the table
     */
    private List<Object> rows;

    /**
     * Creates an instance of DiagnosticDataTableResponseObject class.
     */
    public DiagnosticDataTableResponseObject() {
    }

    /**
     * Get the tableName property: Table name.
     * 
     * @return the tableName value.
     */
    public String tableName() {
        return this.tableName;
    }

    /**
     * Set the tableName property: Table name.
     * 
     * @param tableName the tableName value to set.
     * @return the DiagnosticDataTableResponseObject object itself.
     */
    public DiagnosticDataTableResponseObject withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    /**
     * Get the columns property: Columns in the table.
     * 
     * @return the columns value.
     */
    public List<DiagnosticDataTableResponseColumn> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: Columns in the table.
     * 
     * @param columns the columns value to set.
     * @return the DiagnosticDataTableResponseObject object itself.
     */
    public DiagnosticDataTableResponseObject withColumns(List<DiagnosticDataTableResponseColumn> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the rows property: Rows in the table.
     * 
     * @return the rows value.
     */
    public List<Object> rows() {
        return this.rows;
    }

    /**
     * Set the rows property: Rows in the table.
     * 
     * @param rows the rows value to set.
     * @return the DiagnosticDataTableResponseObject object itself.
     */
    public DiagnosticDataTableResponseObject withRows(List<Object> rows) {
        this.rows = rows;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tableName", this.tableName);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("rows", this.rows, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticDataTableResponseObject from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticDataTableResponseObject if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticDataTableResponseObject.
     */
    public static DiagnosticDataTableResponseObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticDataTableResponseObject deserializedDiagnosticDataTableResponseObject
                = new DiagnosticDataTableResponseObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tableName".equals(fieldName)) {
                    deserializedDiagnosticDataTableResponseObject.tableName = reader.getString();
                } else if ("columns".equals(fieldName)) {
                    List<DiagnosticDataTableResponseColumn> columns
                        = reader.readArray(reader1 -> DiagnosticDataTableResponseColumn.fromJson(reader1));
                    deserializedDiagnosticDataTableResponseObject.columns = columns;
                } else if ("rows".equals(fieldName)) {
                    List<Object> rows = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedDiagnosticDataTableResponseObject.rows = rows;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticDataTableResponseObject;
        });
    }
}
