// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Rendering details of a diagnostics table.
 */
@Fluent
public final class DiagnosticRendering implements JsonSerializable<DiagnosticRendering> {
    /*
     * Rendering type
     */
    private Integer type;

    /*
     * Title of the table
     */
    private String title;

    /*
     * Description of the table
     */
    private String description;

    /*
     * Flag if the table should be rendered
     */
    private Boolean isVisible;

    /**
     * Creates an instance of DiagnosticRendering class.
     */
    public DiagnosticRendering() {
    }

    /**
     * Get the type property: Rendering type.
     * 
     * @return the type value.
     */
    public Integer type() {
        return this.type;
    }

    /**
     * Set the type property: Rendering type.
     * 
     * @param type the type value to set.
     * @return the DiagnosticRendering object itself.
     */
    public DiagnosticRendering withType(Integer type) {
        this.type = type;
        return this;
    }

    /**
     * Get the title property: Title of the table.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Title of the table.
     * 
     * @param title the title value to set.
     * @return the DiagnosticRendering object itself.
     */
    public DiagnosticRendering withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the description property: Description of the table.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the table.
     * 
     * @param description the description value to set.
     * @return the DiagnosticRendering object itself.
     */
    public DiagnosticRendering withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the isVisible property: Flag if the table should be rendered.
     * 
     * @return the isVisible value.
     */
    public Boolean isVisible() {
        return this.isVisible;
    }

    /**
     * Set the isVisible property: Flag if the table should be rendered.
     * 
     * @param isVisible the isVisible value to set.
     * @return the DiagnosticRendering object itself.
     */
    public DiagnosticRendering withIsVisible(Boolean isVisible) {
        this.isVisible = isVisible;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("type", this.type);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("isVisible", this.isVisible);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticRendering from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticRendering if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticRendering.
     */
    public static DiagnosticRendering fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticRendering deserializedDiagnosticRendering = new DiagnosticRendering();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedDiagnosticRendering.type = reader.getNullable(JsonReader::getInt);
                } else if ("title".equals(fieldName)) {
                    deserializedDiagnosticRendering.title = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedDiagnosticRendering.description = reader.getString();
                } else if ("isVisible".equals(fieldName)) {
                    deserializedDiagnosticRendering.isVisible = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticRendering;
        });
    }
}
