// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Support topic information.
 */
@Immutable
public final class DiagnosticSupportTopic implements JsonSerializable<DiagnosticSupportTopic> {
    /*
     * Unique topic identifier
     */
    private String id;

    /*
     * PES identifier
     */
    private String pesId;

    /**
     * Creates an instance of DiagnosticSupportTopic class.
     */
    public DiagnosticSupportTopic() {
    }

    /**
     * Get the id property: Unique topic identifier.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the pesId property: PES identifier.
     * 
     * @return the pesId value.
     */
    public String pesId() {
        return this.pesId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticSupportTopic from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticSupportTopic if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticSupportTopic.
     */
    public static DiagnosticSupportTopic fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticSupportTopic deserializedDiagnosticSupportTopic = new DiagnosticSupportTopic();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDiagnosticSupportTopic.id = reader.getString();
                } else if ("pesId".equals(fieldName)) {
                    deserializedDiagnosticSupportTopic.pesId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticSupportTopic;
        });
    }
}
