// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Metadata of the diagnostics response.
 */
@Fluent
public final class DiagnosticsDefinition implements JsonSerializable<DiagnosticsDefinition> {
    /*
     * Unique detector name
     */
    private String id;

    /*
     * Display Name of the detector
     */
    private String name;

    /*
     * Details of the diagnostics info
     */
    private String description;

    /*
     * Authors' names of the detector
     */
    private String author;

    /*
     * Category of the detector
     */
    private String category;

    /*
     * List of support topics
     */
    private List<DiagnosticSupportTopic> supportTopicList;

    /*
     * List of analysis types
     */
    private List<String> analysisTypes;

    /*
     * Authors' names of the detector
     */
    private String type;

    /*
     * Authors' names of the detector
     */
    private Float score;

    /**
     * Creates an instance of DiagnosticsDefinition class.
     */
    public DiagnosticsDefinition() {
    }

    /**
     * Get the id property: Unique detector name.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Display Name of the detector.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the description property: Details of the diagnostics info.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the author property: Authors' names of the detector.
     * 
     * @return the author value.
     */
    public String author() {
        return this.author;
    }

    /**
     * Get the category property: Category of the detector.
     * 
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Get the supportTopicList property: List of support topics.
     * 
     * @return the supportTopicList value.
     */
    public List<DiagnosticSupportTopic> supportTopicList() {
        return this.supportTopicList;
    }

    /**
     * Set the supportTopicList property: List of support topics.
     * 
     * @param supportTopicList the supportTopicList value to set.
     * @return the DiagnosticsDefinition object itself.
     */
    public DiagnosticsDefinition withSupportTopicList(List<DiagnosticSupportTopic> supportTopicList) {
        this.supportTopicList = supportTopicList;
        return this;
    }

    /**
     * Get the analysisTypes property: List of analysis types.
     * 
     * @return the analysisTypes value.
     */
    public List<String> analysisTypes() {
        return this.analysisTypes;
    }

    /**
     * Set the analysisTypes property: List of analysis types.
     * 
     * @param analysisTypes the analysisTypes value to set.
     * @return the DiagnosticsDefinition object itself.
     */
    public DiagnosticsDefinition withAnalysisTypes(List<String> analysisTypes) {
        this.analysisTypes = analysisTypes;
        return this;
    }

    /**
     * Get the type property: Authors' names of the detector.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the score property: Authors' names of the detector.
     * 
     * @return the score value.
     */
    public Float score() {
        return this.score;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (supportTopicList() != null) {
            supportTopicList().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("supportTopicList", this.supportTopicList,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("analysisTypes", this.analysisTypes,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticsDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticsDefinition if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticsDefinition.
     */
    public static DiagnosticsDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticsDefinition deserializedDiagnosticsDefinition = new DiagnosticsDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.description = reader.getString();
                } else if ("author".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.author = reader.getString();
                } else if ("category".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.category = reader.getString();
                } else if ("supportTopicList".equals(fieldName)) {
                    List<DiagnosticSupportTopic> supportTopicList
                        = reader.readArray(reader1 -> DiagnosticSupportTopic.fromJson(reader1));
                    deserializedDiagnosticsDefinition.supportTopicList = supportTopicList;
                } else if ("analysisTypes".equals(fieldName)) {
                    List<String> analysisTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedDiagnosticsDefinition.analysisTypes = analysisTypes;
                } else if ("type".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.type = reader.getString();
                } else if ("score".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.score = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticsDefinition;
        });
    }
}
