// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Diagnostics resource specific properties.
 */
@Fluent
public final class DiagnosticsProperties implements JsonSerializable<DiagnosticsProperties> {
    /*
     * Metadata of the diagnostics response.
     */
    private DiagnosticsDefinition metadata;

    /*
     * Set of data collections associated with the response.
     */
    private List<DiagnosticsDataApiResponse> dataset;

    /*
     * Status of the diagnostics response.
     */
    private DiagnosticsStatus status;

    /*
     * List of data providers' metadata.
     */
    private DiagnosticDataProviderMetadata dataProviderMetadata;

    /**
     * Creates an instance of DiagnosticsProperties class.
     */
    public DiagnosticsProperties() {
    }

    /**
     * Get the metadata property: Metadata of the diagnostics response.
     * 
     * @return the metadata value.
     */
    public DiagnosticsDefinition metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Metadata of the diagnostics response.
     * 
     * @param metadata the metadata value to set.
     * @return the DiagnosticsProperties object itself.
     */
    public DiagnosticsProperties withMetadata(DiagnosticsDefinition metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the dataset property: Set of data collections associated with the response.
     * 
     * @return the dataset value.
     */
    public List<DiagnosticsDataApiResponse> dataset() {
        return this.dataset;
    }

    /**
     * Set the dataset property: Set of data collections associated with the response.
     * 
     * @param dataset the dataset value to set.
     * @return the DiagnosticsProperties object itself.
     */
    public DiagnosticsProperties withDataset(List<DiagnosticsDataApiResponse> dataset) {
        this.dataset = dataset;
        return this;
    }

    /**
     * Get the status property: Status of the diagnostics response.
     * 
     * @return the status value.
     */
    public DiagnosticsStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Status of the diagnostics response.
     * 
     * @param status the status value to set.
     * @return the DiagnosticsProperties object itself.
     */
    public DiagnosticsProperties withStatus(DiagnosticsStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the dataProviderMetadata property: List of data providers' metadata.
     * 
     * @return the dataProviderMetadata value.
     */
    public DiagnosticDataProviderMetadata dataProviderMetadata() {
        return this.dataProviderMetadata;
    }

    /**
     * Set the dataProviderMetadata property: List of data providers' metadata.
     * 
     * @param dataProviderMetadata the dataProviderMetadata value to set.
     * @return the DiagnosticsProperties object itself.
     */
    public DiagnosticsProperties withDataProviderMetadata(DiagnosticDataProviderMetadata dataProviderMetadata) {
        this.dataProviderMetadata = dataProviderMetadata;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metadata() != null) {
            metadata().validate();
        }
        if (dataset() != null) {
            dataset().forEach(e -> e.validate());
        }
        if (status() != null) {
            status().validate();
        }
        if (dataProviderMetadata() != null) {
            dataProviderMetadata().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("metadata", this.metadata);
        jsonWriter.writeArrayField("dataset", this.dataset, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("status", this.status);
        jsonWriter.writeJsonField("dataProviderMetadata", this.dataProviderMetadata);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticsProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticsProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticsProperties.
     */
    public static DiagnosticsProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticsProperties deserializedDiagnosticsProperties = new DiagnosticsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metadata".equals(fieldName)) {
                    deserializedDiagnosticsProperties.metadata = DiagnosticsDefinition.fromJson(reader);
                } else if ("dataset".equals(fieldName)) {
                    List<DiagnosticsDataApiResponse> dataset
                        = reader.readArray(reader1 -> DiagnosticsDataApiResponse.fromJson(reader1));
                    deserializedDiagnosticsProperties.dataset = dataset;
                } else if ("status".equals(fieldName)) {
                    deserializedDiagnosticsProperties.status = DiagnosticsStatus.fromJson(reader);
                } else if ("dataProviderMetadata".equals(fieldName)) {
                    deserializedDiagnosticsProperties.dataProviderMetadata
                        = DiagnosticDataProviderMetadata.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticsProperties;
        });
    }
}
