// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Rendering details of a diagnostics table.
 */
@Fluent
public final class DiagnosticsStatus implements JsonSerializable<DiagnosticsStatus> {
    /*
     * Diagnostic message
     */
    private String message;

    /*
     * Status
     */
    private Integer statusId;

    /**
     * Creates an instance of DiagnosticsStatus class.
     */
    public DiagnosticsStatus() {
    }

    /**
     * Get the message property: Diagnostic message.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Diagnostic message.
     * 
     * @param message the message value to set.
     * @return the DiagnosticsStatus object itself.
     */
    public DiagnosticsStatus withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the statusId property: Status.
     * 
     * @return the statusId value.
     */
    public Integer statusId() {
        return this.statusId;
    }

    /**
     * Set the statusId property: Status.
     * 
     * @param statusId the statusId value to set.
     * @return the DiagnosticsStatus object itself.
     */
    public DiagnosticsStatus withStatusId(Integer statusId) {
        this.statusId = statusId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeNumberField("statusId", this.statusId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticsStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticsStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticsStatus.
     */
    public static DiagnosticsStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticsStatus deserializedDiagnosticsStatus = new DiagnosticsStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("message".equals(fieldName)) {
                    deserializedDiagnosticsStatus.message = reader.getString();
                } else if ("statusId".equals(fieldName)) {
                    deserializedDiagnosticsStatus.statusId = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticsStatus;
        });
    }
}
