// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.DotNetComponentInner;
import java.util.List;

/**
 * An immutable client-side representation of DotNetComponent.
 */
public interface DotNetComponent {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the componentType property: Type of the .NET Component.
     * 
     * @return the componentType value.
     */
    DotNetComponentType componentType();

    /**
     * Gets the provisioningState property: Provisioning state of the .NET Component.
     * 
     * @return the provisioningState value.
     */
    DotNetComponentProvisioningState provisioningState();

    /**
     * Gets the configurations property: List of .NET Components configuration properties.
     * 
     * @return the configurations value.
     */
    List<DotNetComponentConfigurationProperty> configurations();

    /**
     * Gets the serviceBinds property: List of .NET Components that are bound to the .NET component.
     * 
     * @return the serviceBinds value.
     */
    List<DotNetComponentServiceBind> serviceBinds();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.DotNetComponentInner object.
     * 
     * @return the inner object.
     */
    DotNetComponentInner innerModel();

    /**
     * The entirety of the DotNetComponent definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The DotNetComponent definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the DotNetComponent definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the DotNetComponent definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, environmentName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param environmentName Name of the Managed Environment.
             * @return the next definition stage.
             */
            WithCreate withExistingManagedEnvironment(String resourceGroupName, String environmentName);
        }

        /**
         * The stage of the DotNetComponent definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithComponentType, DefinitionStages.WithConfigurations,
            DefinitionStages.WithServiceBinds {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            DotNetComponent create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            DotNetComponent create(Context context);
        }

        /**
         * The stage of the DotNetComponent definition allowing to specify componentType.
         */
        interface WithComponentType {
            /**
             * Specifies the componentType property: Type of the .NET Component..
             * 
             * @param componentType Type of the .NET Component.
             * @return the next definition stage.
             */
            WithCreate withComponentType(DotNetComponentType componentType);
        }

        /**
         * The stage of the DotNetComponent definition allowing to specify configurations.
         */
        interface WithConfigurations {
            /**
             * Specifies the configurations property: List of .NET Components configuration properties.
             * 
             * @param configurations List of .NET Components configuration properties.
             * @return the next definition stage.
             */
            WithCreate withConfigurations(List<DotNetComponentConfigurationProperty> configurations);
        }

        /**
         * The stage of the DotNetComponent definition allowing to specify serviceBinds.
         */
        interface WithServiceBinds {
            /**
             * Specifies the serviceBinds property: List of .NET Components that are bound to the .NET component.
             * 
             * @param serviceBinds List of .NET Components that are bound to the .NET component.
             * @return the next definition stage.
             */
            WithCreate withServiceBinds(List<DotNetComponentServiceBind> serviceBinds);
        }
    }

    /**
     * Begins update for the DotNetComponent resource.
     * 
     * @return the stage of resource update.
     */
    DotNetComponent.Update update();

    /**
     * The template for DotNetComponent update.
     */
    interface Update
        extends UpdateStages.WithComponentType, UpdateStages.WithConfigurations, UpdateStages.WithServiceBinds {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        DotNetComponent apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        DotNetComponent apply(Context context);
    }

    /**
     * The DotNetComponent update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the DotNetComponent update allowing to specify componentType.
         */
        interface WithComponentType {
            /**
             * Specifies the componentType property: Type of the .NET Component..
             * 
             * @param componentType Type of the .NET Component.
             * @return the next definition stage.
             */
            Update withComponentType(DotNetComponentType componentType);
        }

        /**
         * The stage of the DotNetComponent update allowing to specify configurations.
         */
        interface WithConfigurations {
            /**
             * Specifies the configurations property: List of .NET Components configuration properties.
             * 
             * @param configurations List of .NET Components configuration properties.
             * @return the next definition stage.
             */
            Update withConfigurations(List<DotNetComponentConfigurationProperty> configurations);
        }

        /**
         * The stage of the DotNetComponent update allowing to specify serviceBinds.
         */
        interface WithServiceBinds {
            /**
             * Specifies the serviceBinds property: List of .NET Components that are bound to the .NET component.
             * 
             * @param serviceBinds List of .NET Components that are bound to the .NET component.
             * @return the next definition stage.
             */
            Update withServiceBinds(List<DotNetComponentServiceBind> serviceBinds);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    DotNetComponent refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    DotNetComponent refresh(Context context);
}
