// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration properties for a .NET Component.
 */
@Fluent
public final class DotNetComponentConfigurationProperty
    implements JsonSerializable<DotNetComponentConfigurationProperty> {
    /*
     * The name of the property
     */
    private String propertyName;

    /*
     * The value of the property
     */
    private String value;

    /**
     * Creates an instance of DotNetComponentConfigurationProperty class.
     */
    public DotNetComponentConfigurationProperty() {
    }

    /**
     * Get the propertyName property: The name of the property.
     * 
     * @return the propertyName value.
     */
    public String propertyName() {
        return this.propertyName;
    }

    /**
     * Set the propertyName property: The name of the property.
     * 
     * @param propertyName the propertyName value to set.
     * @return the DotNetComponentConfigurationProperty object itself.
     */
    public DotNetComponentConfigurationProperty withPropertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    /**
     * Get the value property: The value of the property.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the property.
     * 
     * @param value the value value to set.
     * @return the DotNetComponentConfigurationProperty object itself.
     */
    public DotNetComponentConfigurationProperty withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("propertyName", this.propertyName);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DotNetComponentConfigurationProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DotNetComponentConfigurationProperty if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DotNetComponentConfigurationProperty.
     */
    public static DotNetComponentConfigurationProperty fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DotNetComponentConfigurationProperty deserializedDotNetComponentConfigurationProperty
                = new DotNetComponentConfigurationProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("propertyName".equals(fieldName)) {
                    deserializedDotNetComponentConfigurationProperty.propertyName = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedDotNetComponentConfigurationProperty.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDotNetComponentConfigurationProperty;
        });
    }
}
