// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration to bind a .NET Component to another .NET Component.
 */
@Fluent
public final class DotNetComponentServiceBind implements JsonSerializable<DotNetComponentServiceBind> {
    /*
     * Name of the service bind
     */
    private String name;

    /*
     * Resource id of the target service
     */
    private String serviceId;

    /**
     * Creates an instance of DotNetComponentServiceBind class.
     */
    public DotNetComponentServiceBind() {
    }

    /**
     * Get the name property: Name of the service bind.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the service bind.
     * 
     * @param name the name value to set.
     * @return the DotNetComponentServiceBind object itself.
     */
    public DotNetComponentServiceBind withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the serviceId property: Resource id of the target service.
     * 
     * @return the serviceId value.
     */
    public String serviceId() {
        return this.serviceId;
    }

    /**
     * Set the serviceId property: Resource id of the target service.
     * 
     * @param serviceId the serviceId value to set.
     * @return the DotNetComponentServiceBind object itself.
     */
    public DotNetComponentServiceBind withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("serviceId", this.serviceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DotNetComponentServiceBind from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DotNetComponentServiceBind if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DotNetComponentServiceBind.
     */
    public static DotNetComponentServiceBind fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DotNetComponentServiceBind deserializedDotNetComponentServiceBind = new DotNetComponentServiceBind();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDotNetComponentServiceBind.name = reader.getString();
                } else if ("serviceId".equals(fieldName)) {
                    deserializedDotNetComponentServiceBind.serviceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDotNetComponentServiceBind;
        });
    }
}
