// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Dynamic pool configuration.
 */
@Fluent
public final class DynamicPoolConfiguration implements JsonSerializable<DynamicPoolConfiguration> {
    /*
     * The execution type of the session pool.
     */
    private ExecutionType executionType;

    /*
     * The cooldown period of a session in seconds.
     */
    private Integer cooldownPeriodInSeconds;

    /**
     * Creates an instance of DynamicPoolConfiguration class.
     */
    public DynamicPoolConfiguration() {
    }

    /**
     * Get the executionType property: The execution type of the session pool.
     * 
     * @return the executionType value.
     */
    public ExecutionType executionType() {
        return this.executionType;
    }

    /**
     * Set the executionType property: The execution type of the session pool.
     * 
     * @param executionType the executionType value to set.
     * @return the DynamicPoolConfiguration object itself.
     */
    public DynamicPoolConfiguration withExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    /**
     * Get the cooldownPeriodInSeconds property: The cooldown period of a session in seconds.
     * 
     * @return the cooldownPeriodInSeconds value.
     */
    public Integer cooldownPeriodInSeconds() {
        return this.cooldownPeriodInSeconds;
    }

    /**
     * Set the cooldownPeriodInSeconds property: The cooldown period of a session in seconds.
     * 
     * @param cooldownPeriodInSeconds the cooldownPeriodInSeconds value to set.
     * @return the DynamicPoolConfiguration object itself.
     */
    public DynamicPoolConfiguration withCooldownPeriodInSeconds(Integer cooldownPeriodInSeconds) {
        this.cooldownPeriodInSeconds = cooldownPeriodInSeconds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("executionType", this.executionType == null ? null : this.executionType.toString());
        jsonWriter.writeNumberField("cooldownPeriodInSeconds", this.cooldownPeriodInSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DynamicPoolConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DynamicPoolConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DynamicPoolConfiguration.
     */
    public static DynamicPoolConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DynamicPoolConfiguration deserializedDynamicPoolConfiguration = new DynamicPoolConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("executionType".equals(fieldName)) {
                    deserializedDynamicPoolConfiguration.executionType = ExecutionType.fromString(reader.getString());
                } else if ("cooldownPeriodInSeconds".equals(fieldName)) {
                    deserializedDynamicPoolConfiguration.cooldownPeriodInSeconds
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDynamicPoolConfiguration;
        });
    }
}
