// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the secrets references of encryption key and signing key for ContainerApp Service
 * Authentication/Authorization.
 */
@Fluent
public final class EncryptionSettings implements JsonSerializable<EncryptionSettings> {
    /*
     * The secret name which is referenced for EncryptionKey.
     */
    private String containerAppAuthEncryptionSecretName;

    /*
     * The secret name which is referenced for SigningKey.
     */
    private String containerAppAuthSigningSecretName;

    /**
     * Creates an instance of EncryptionSettings class.
     */
    public EncryptionSettings() {
    }

    /**
     * Get the containerAppAuthEncryptionSecretName property: The secret name which is referenced for EncryptionKey.
     * 
     * @return the containerAppAuthEncryptionSecretName value.
     */
    public String containerAppAuthEncryptionSecretName() {
        return this.containerAppAuthEncryptionSecretName;
    }

    /**
     * Set the containerAppAuthEncryptionSecretName property: The secret name which is referenced for EncryptionKey.
     * 
     * @param containerAppAuthEncryptionSecretName the containerAppAuthEncryptionSecretName value to set.
     * @return the EncryptionSettings object itself.
     */
    public EncryptionSettings withContainerAppAuthEncryptionSecretName(String containerAppAuthEncryptionSecretName) {
        this.containerAppAuthEncryptionSecretName = containerAppAuthEncryptionSecretName;
        return this;
    }

    /**
     * Get the containerAppAuthSigningSecretName property: The secret name which is referenced for SigningKey.
     * 
     * @return the containerAppAuthSigningSecretName value.
     */
    public String containerAppAuthSigningSecretName() {
        return this.containerAppAuthSigningSecretName;
    }

    /**
     * Set the containerAppAuthSigningSecretName property: The secret name which is referenced for SigningKey.
     * 
     * @param containerAppAuthSigningSecretName the containerAppAuthSigningSecretName value to set.
     * @return the EncryptionSettings object itself.
     */
    public EncryptionSettings withContainerAppAuthSigningSecretName(String containerAppAuthSigningSecretName) {
        this.containerAppAuthSigningSecretName = containerAppAuthSigningSecretName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerAppAuthEncryptionSecretName", this.containerAppAuthEncryptionSecretName);
        jsonWriter.writeStringField("containerAppAuthSigningSecretName", this.containerAppAuthSigningSecretName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionSettings.
     */
    public static EncryptionSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionSettings deserializedEncryptionSettings = new EncryptionSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("containerAppAuthEncryptionSecretName".equals(fieldName)) {
                    deserializedEncryptionSettings.containerAppAuthEncryptionSecretName = reader.getString();
                } else if ("containerAppAuthSigningSecretName".equals(fieldName)) {
                    deserializedEncryptionSettings.containerAppAuthSigningSecretName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionSettings;
        });
    }
}
