// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container App container environment variable.
 */
@Fluent
public final class EnvironmentVar implements JsonSerializable<EnvironmentVar> {
    /*
     * Environment variable name.
     */
    private String name;

    /*
     * Non-secret environment variable value.
     */
    private String value;

    /*
     * Name of the Container App secret from which to pull the environment variable value.
     */
    private String secretRef;

    /**
     * Creates an instance of EnvironmentVar class.
     */
    public EnvironmentVar() {
    }

    /**
     * Get the name property: Environment variable name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Environment variable name.
     * 
     * @param name the name value to set.
     * @return the EnvironmentVar object itself.
     */
    public EnvironmentVar withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: Non-secret environment variable value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Non-secret environment variable value.
     * 
     * @param value the value value to set.
     * @return the EnvironmentVar object itself.
     */
    public EnvironmentVar withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the secretRef property: Name of the Container App secret from which to pull the environment variable value.
     * 
     * @return the secretRef value.
     */
    public String secretRef() {
        return this.secretRef;
    }

    /**
     * Set the secretRef property: Name of the Container App secret from which to pull the environment variable value.
     * 
     * @param secretRef the secretRef value to set.
     * @return the EnvironmentVar object itself.
     */
    public EnvironmentVar withSecretRef(String secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("secretRef", this.secretRef);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EnvironmentVar from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EnvironmentVar if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EnvironmentVar.
     */
    public static EnvironmentVar fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EnvironmentVar deserializedEnvironmentVar = new EnvironmentVar();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedEnvironmentVar.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedEnvironmentVar.value = reader.getString();
                } else if ("secretRef".equals(fieldName)) {
                    deserializedEnvironmentVar.secretRef = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEnvironmentVar;
        });
    }
}
