// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Container Apps Job execution status.
 */
@Fluent
public final class ExecutionStatus implements JsonSerializable<ExecutionStatus> {
    /*
     * Replicas in the execution.
     */
    private List<ReplicaExecutionStatus> replicas;

    /**
     * Creates an instance of ExecutionStatus class.
     */
    public ExecutionStatus() {
    }

    /**
     * Get the replicas property: Replicas in the execution.
     * 
     * @return the replicas value.
     */
    public List<ReplicaExecutionStatus> replicas() {
        return this.replicas;
    }

    /**
     * Set the replicas property: Replicas in the execution.
     * 
     * @param replicas the replicas value to set.
     * @return the ExecutionStatus object itself.
     */
    public ExecutionStatus withReplicas(List<ReplicaExecutionStatus> replicas) {
        this.replicas = replicas;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (replicas() != null) {
            replicas().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("replicas", this.replicas, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExecutionStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExecutionStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExecutionStatus.
     */
    public static ExecutionStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExecutionStatus deserializedExecutionStatus = new ExecutionStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("replicas".equals(fieldName)) {
                    List<ReplicaExecutionStatus> replicas
                        = reader.readArray(reader1 -> ReplicaExecutionStatus.fromJson(reader1));
                    deserializedExecutionStatus.replicas = replicas;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExecutionStatus;
        });
    }
}
