// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The configuration settings that determines the validation flow of users using ContainerApp Service
 * Authentication/Authorization.
 */
@Fluent
public final class GlobalValidation implements JsonSerializable<GlobalValidation> {
    /*
     * The action to take when an unauthenticated client attempts to access the app.
     */
    private UnauthenticatedClientActionV2 unauthenticatedClientAction;

    /*
     * The default authentication provider to use when multiple providers are configured.
     * This setting is only needed if multiple providers are configured and the unauthenticated client
     * action is set to "RedirectToLoginPage".
     */
    private String redirectToProvider;

    /*
     * The paths for which unauthenticated flow would not be redirected to the login page.
     */
    private List<String> excludedPaths;

    /**
     * Creates an instance of GlobalValidation class.
     */
    public GlobalValidation() {
    }

    /**
     * Get the unauthenticatedClientAction property: The action to take when an unauthenticated client attempts to
     * access the app.
     * 
     * @return the unauthenticatedClientAction value.
     */
    public UnauthenticatedClientActionV2 unauthenticatedClientAction() {
        return this.unauthenticatedClientAction;
    }

    /**
     * Set the unauthenticatedClientAction property: The action to take when an unauthenticated client attempts to
     * access the app.
     * 
     * @param unauthenticatedClientAction the unauthenticatedClientAction value to set.
     * @return the GlobalValidation object itself.
     */
    public GlobalValidation withUnauthenticatedClientAction(UnauthenticatedClientActionV2 unauthenticatedClientAction) {
        this.unauthenticatedClientAction = unauthenticatedClientAction;
        return this;
    }

    /**
     * Get the redirectToProvider property: The default authentication provider to use when multiple providers are
     * configured.
     * This setting is only needed if multiple providers are configured and the unauthenticated client
     * action is set to "RedirectToLoginPage".
     * 
     * @return the redirectToProvider value.
     */
    public String redirectToProvider() {
        return this.redirectToProvider;
    }

    /**
     * Set the redirectToProvider property: The default authentication provider to use when multiple providers are
     * configured.
     * This setting is only needed if multiple providers are configured and the unauthenticated client
     * action is set to "RedirectToLoginPage".
     * 
     * @param redirectToProvider the redirectToProvider value to set.
     * @return the GlobalValidation object itself.
     */
    public GlobalValidation withRedirectToProvider(String redirectToProvider) {
        this.redirectToProvider = redirectToProvider;
        return this;
    }

    /**
     * Get the excludedPaths property: The paths for which unauthenticated flow would not be redirected to the login
     * page.
     * 
     * @return the excludedPaths value.
     */
    public List<String> excludedPaths() {
        return this.excludedPaths;
    }

    /**
     * Set the excludedPaths property: The paths for which unauthenticated flow would not be redirected to the login
     * page.
     * 
     * @param excludedPaths the excludedPaths value to set.
     * @return the GlobalValidation object itself.
     */
    public GlobalValidation withExcludedPaths(List<String> excludedPaths) {
        this.excludedPaths = excludedPaths;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("unauthenticatedClientAction",
            this.unauthenticatedClientAction == null ? null : this.unauthenticatedClientAction.toString());
        jsonWriter.writeStringField("redirectToProvider", this.redirectToProvider);
        jsonWriter.writeArrayField("excludedPaths", this.excludedPaths,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GlobalValidation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GlobalValidation if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the GlobalValidation.
     */
    public static GlobalValidation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GlobalValidation deserializedGlobalValidation = new GlobalValidation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("unauthenticatedClientAction".equals(fieldName)) {
                    deserializedGlobalValidation.unauthenticatedClientAction
                        = UnauthenticatedClientActionV2.fromString(reader.getString());
                } else if ("redirectToProvider".equals(fieldName)) {
                    deserializedGlobalValidation.redirectToProvider = reader.getString();
                } else if ("excludedPaths".equals(fieldName)) {
                    List<String> excludedPaths = reader.readArray(reader1 -> reader1.getString());
                    deserializedGlobalValidation.excludedPaths = excludedPaths;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGlobalValidation;
        });
    }
}
