// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Header of otlp configuration.
 */
@Fluent
public final class Header implements JsonSerializable<Header> {
    /*
     * The key of otlp configuration header
     */
    private String key;

    /*
     * The value of otlp configuration header
     */
    private String value;

    /**
     * Creates an instance of Header class.
     */
    public Header() {
    }

    /**
     * Get the key property: The key of otlp configuration header.
     * 
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Set the key property: The key of otlp configuration header.
     * 
     * @param key the key value to set.
     * @return the Header object itself.
     */
    public Header withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Get the value property: The value of otlp configuration header.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of otlp configuration header.
     * 
     * @param value the value value to set.
     * @return the Header object itself.
     */
    public Header withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Header from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Header if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Header.
     */
    public static Header fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Header deserializedHeader = new Header();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("key".equals(fieldName)) {
                    deserializedHeader.key = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedHeader.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHeader;
        });
    }
}
