// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines parameters for http connection pooling.
 */
@Fluent
public final class HttpConnectionPool implements JsonSerializable<HttpConnectionPool> {
    /*
     * Maximum number of pending http1 requests allowed
     */
    private Integer http1MaxPendingRequests;

    /*
     * Maximum number of http2 requests allowed
     */
    private Integer http2MaxRequests;

    /**
     * Creates an instance of HttpConnectionPool class.
     */
    public HttpConnectionPool() {
    }

    /**
     * Get the http1MaxPendingRequests property: Maximum number of pending http1 requests allowed.
     * 
     * @return the http1MaxPendingRequests value.
     */
    public Integer http1MaxPendingRequests() {
        return this.http1MaxPendingRequests;
    }

    /**
     * Set the http1MaxPendingRequests property: Maximum number of pending http1 requests allowed.
     * 
     * @param http1MaxPendingRequests the http1MaxPendingRequests value to set.
     * @return the HttpConnectionPool object itself.
     */
    public HttpConnectionPool withHttp1MaxPendingRequests(Integer http1MaxPendingRequests) {
        this.http1MaxPendingRequests = http1MaxPendingRequests;
        return this;
    }

    /**
     * Get the http2MaxRequests property: Maximum number of http2 requests allowed.
     * 
     * @return the http2MaxRequests value.
     */
    public Integer http2MaxRequests() {
        return this.http2MaxRequests;
    }

    /**
     * Set the http2MaxRequests property: Maximum number of http2 requests allowed.
     * 
     * @param http2MaxRequests the http2MaxRequests value to set.
     * @return the HttpConnectionPool object itself.
     */
    public HttpConnectionPool withHttp2MaxRequests(Integer http2MaxRequests) {
        this.http2MaxRequests = http2MaxRequests;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("http1MaxPendingRequests", this.http1MaxPendingRequests);
        jsonWriter.writeNumberField("http2MaxRequests", this.http2MaxRequests);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpConnectionPool from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpConnectionPool if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HttpConnectionPool.
     */
    public static HttpConnectionPool fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpConnectionPool deserializedHttpConnectionPool = new HttpConnectionPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("http1MaxPendingRequests".equals(fieldName)) {
                    deserializedHttpConnectionPool.http1MaxPendingRequests = reader.getNullable(JsonReader::getInt);
                } else if ("http2MaxRequests".equals(fieldName)) {
                    deserializedHttpConnectionPool.http2MaxRequests = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpConnectionPool;
        });
    }
}
