// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Model representing a http get request.
 */
@Fluent
public final class HttpGet implements JsonSerializable<HttpGet> {
    /*
     * URL to make HTTP GET request against.
     */
    private String url;

    /*
     * Name of the file that the request should be saved to.
     */
    private String fileName;

    /*
     * List of headers to send with the request.
     */
    private List<String> headers;

    /**
     * Creates an instance of HttpGet class.
     */
    public HttpGet() {
    }

    /**
     * Get the url property: URL to make HTTP GET request against.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: URL to make HTTP GET request against.
     * 
     * @param url the url value to set.
     * @return the HttpGet object itself.
     */
    public HttpGet withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the fileName property: Name of the file that the request should be saved to.
     * 
     * @return the fileName value.
     */
    public String fileName() {
        return this.fileName;
    }

    /**
     * Set the fileName property: Name of the file that the request should be saved to.
     * 
     * @param fileName the fileName value to set.
     * @return the HttpGet object itself.
     */
    public HttpGet withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the headers property: List of headers to send with the request.
     * 
     * @return the headers value.
     */
    public List<String> headers() {
        return this.headers;
    }

    /**
     * Set the headers property: List of headers to send with the request.
     * 
     * @param headers the headers value to set.
     * @return the HttpGet object itself.
     */
    public HttpGet withHeaders(List<String> headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (url() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property url in model HttpGet"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HttpGet.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("fileName", this.fileName);
        jsonWriter.writeArrayField("headers", this.headers, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpGet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpGet if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the HttpGet.
     */
    public static HttpGet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpGet deserializedHttpGet = new HttpGet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("url".equals(fieldName)) {
                    deserializedHttpGet.url = reader.getString();
                } else if ("fileName".equals(fieldName)) {
                    deserializedHttpGet.fileName = reader.getString();
                } else if ("headers".equals(fieldName)) {
                    List<String> headers = reader.readArray(reader1 -> reader1.getString());
                    deserializedHttpGet.headers = headers;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpGet;
        });
    }
}
