// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the HTTP requests for authentication and authorization requests made against
 * ContainerApp Service Authentication/Authorization.
 */
@Fluent
public final class HttpSettings implements JsonSerializable<HttpSettings> {
    /*
     * <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible;
     * otherwise, <code>true</code>.
     */
    private Boolean requireHttps;

    /*
     * The configuration settings of the paths HTTP requests.
     */
    private HttpSettingsRoutes routes;

    /*
     * The configuration settings of a forward proxy used to make the requests.
     */
    private ForwardProxy forwardProxy;

    /**
     * Creates an instance of HttpSettings class.
     */
    public HttpSettings() {
    }

    /**
     * Get the requireHttps property: &lt;code&gt;false&lt;/code&gt; if the authentication/authorization responses not
     * having the HTTPS scheme are permissible; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @return the requireHttps value.
     */
    public Boolean requireHttps() {
        return this.requireHttps;
    }

    /**
     * Set the requireHttps property: &lt;code&gt;false&lt;/code&gt; if the authentication/authorization responses not
     * having the HTTPS scheme are permissible; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @param requireHttps the requireHttps value to set.
     * @return the HttpSettings object itself.
     */
    public HttpSettings withRequireHttps(Boolean requireHttps) {
        this.requireHttps = requireHttps;
        return this;
    }

    /**
     * Get the routes property: The configuration settings of the paths HTTP requests.
     * 
     * @return the routes value.
     */
    public HttpSettingsRoutes routes() {
        return this.routes;
    }

    /**
     * Set the routes property: The configuration settings of the paths HTTP requests.
     * 
     * @param routes the routes value to set.
     * @return the HttpSettings object itself.
     */
    public HttpSettings withRoutes(HttpSettingsRoutes routes) {
        this.routes = routes;
        return this;
    }

    /**
     * Get the forwardProxy property: The configuration settings of a forward proxy used to make the requests.
     * 
     * @return the forwardProxy value.
     */
    public ForwardProxy forwardProxy() {
        return this.forwardProxy;
    }

    /**
     * Set the forwardProxy property: The configuration settings of a forward proxy used to make the requests.
     * 
     * @param forwardProxy the forwardProxy value to set.
     * @return the HttpSettings object itself.
     */
    public HttpSettings withForwardProxy(ForwardProxy forwardProxy) {
        this.forwardProxy = forwardProxy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routes() != null) {
            routes().validate();
        }
        if (forwardProxy() != null) {
            forwardProxy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("requireHttps", this.requireHttps);
        jsonWriter.writeJsonField("routes", this.routes);
        jsonWriter.writeJsonField("forwardProxy", this.forwardProxy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HttpSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HttpSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HttpSettings.
     */
    public static HttpSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HttpSettings deserializedHttpSettings = new HttpSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("requireHttps".equals(fieldName)) {
                    deserializedHttpSettings.requireHttps = reader.getNullable(JsonReader::getBoolean);
                } else if ("routes".equals(fieldName)) {
                    deserializedHttpSettings.routes = HttpSettingsRoutes.fromJson(reader);
                } else if ("forwardProxy".equals(fieldName)) {
                    deserializedHttpSettings.forwardProxy = ForwardProxy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHttpSettings;
        });
    }
}
