// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The configuration settings of each of the identity providers used to configure ContainerApp Service
 * Authentication/Authorization.
 */
@Fluent
public final class IdentityProviders implements JsonSerializable<IdentityProviders> {
    /*
     * The configuration settings of the Azure Active directory provider.
     */
    private AzureActiveDirectory azureActiveDirectory;

    /*
     * The configuration settings of the Facebook provider.
     */
    private Facebook facebook;

    /*
     * The configuration settings of the GitHub provider.
     */
    private GitHub gitHub;

    /*
     * The configuration settings of the Google provider.
     */
    private Google google;

    /*
     * The configuration settings of the Twitter provider.
     */
    private Twitter twitter;

    /*
     * The configuration settings of the Apple provider.
     */
    private Apple apple;

    /*
     * The configuration settings of the Azure Static Web Apps provider.
     */
    private AzureStaticWebApps azureStaticWebApps;

    /*
     * The map of the name of the alias of each custom Open ID Connect provider to the
     * configuration settings of the custom Open ID Connect provider.
     */
    private Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders;

    /**
     * Creates an instance of IdentityProviders class.
     */
    public IdentityProviders() {
    }

    /**
     * Get the azureActiveDirectory property: The configuration settings of the Azure Active directory provider.
     * 
     * @return the azureActiveDirectory value.
     */
    public AzureActiveDirectory azureActiveDirectory() {
        return this.azureActiveDirectory;
    }

    /**
     * Set the azureActiveDirectory property: The configuration settings of the Azure Active directory provider.
     * 
     * @param azureActiveDirectory the azureActiveDirectory value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withAzureActiveDirectory(AzureActiveDirectory azureActiveDirectory) {
        this.azureActiveDirectory = azureActiveDirectory;
        return this;
    }

    /**
     * Get the facebook property: The configuration settings of the Facebook provider.
     * 
     * @return the facebook value.
     */
    public Facebook facebook() {
        return this.facebook;
    }

    /**
     * Set the facebook property: The configuration settings of the Facebook provider.
     * 
     * @param facebook the facebook value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withFacebook(Facebook facebook) {
        this.facebook = facebook;
        return this;
    }

    /**
     * Get the gitHub property: The configuration settings of the GitHub provider.
     * 
     * @return the gitHub value.
     */
    public GitHub gitHub() {
        return this.gitHub;
    }

    /**
     * Set the gitHub property: The configuration settings of the GitHub provider.
     * 
     * @param gitHub the gitHub value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withGitHub(GitHub gitHub) {
        this.gitHub = gitHub;
        return this;
    }

    /**
     * Get the google property: The configuration settings of the Google provider.
     * 
     * @return the google value.
     */
    public Google google() {
        return this.google;
    }

    /**
     * Set the google property: The configuration settings of the Google provider.
     * 
     * @param google the google value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withGoogle(Google google) {
        this.google = google;
        return this;
    }

    /**
     * Get the twitter property: The configuration settings of the Twitter provider.
     * 
     * @return the twitter value.
     */
    public Twitter twitter() {
        return this.twitter;
    }

    /**
     * Set the twitter property: The configuration settings of the Twitter provider.
     * 
     * @param twitter the twitter value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withTwitter(Twitter twitter) {
        this.twitter = twitter;
        return this;
    }

    /**
     * Get the apple property: The configuration settings of the Apple provider.
     * 
     * @return the apple value.
     */
    public Apple apple() {
        return this.apple;
    }

    /**
     * Set the apple property: The configuration settings of the Apple provider.
     * 
     * @param apple the apple value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withApple(Apple apple) {
        this.apple = apple;
        return this;
    }

    /**
     * Get the azureStaticWebApps property: The configuration settings of the Azure Static Web Apps provider.
     * 
     * @return the azureStaticWebApps value.
     */
    public AzureStaticWebApps azureStaticWebApps() {
        return this.azureStaticWebApps;
    }

    /**
     * Set the azureStaticWebApps property: The configuration settings of the Azure Static Web Apps provider.
     * 
     * @param azureStaticWebApps the azureStaticWebApps value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders withAzureStaticWebApps(AzureStaticWebApps azureStaticWebApps) {
        this.azureStaticWebApps = azureStaticWebApps;
        return this;
    }

    /**
     * Get the customOpenIdConnectProviders property: The map of the name of the alias of each custom Open ID Connect
     * provider to the
     * configuration settings of the custom Open ID Connect provider.
     * 
     * @return the customOpenIdConnectProviders value.
     */
    public Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders() {
        return this.customOpenIdConnectProviders;
    }

    /**
     * Set the customOpenIdConnectProviders property: The map of the name of the alias of each custom Open ID Connect
     * provider to the
     * configuration settings of the custom Open ID Connect provider.
     * 
     * @param customOpenIdConnectProviders the customOpenIdConnectProviders value to set.
     * @return the IdentityProviders object itself.
     */
    public IdentityProviders
        withCustomOpenIdConnectProviders(Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders) {
        this.customOpenIdConnectProviders = customOpenIdConnectProviders;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (azureActiveDirectory() != null) {
            azureActiveDirectory().validate();
        }
        if (facebook() != null) {
            facebook().validate();
        }
        if (gitHub() != null) {
            gitHub().validate();
        }
        if (google() != null) {
            google().validate();
        }
        if (twitter() != null) {
            twitter().validate();
        }
        if (apple() != null) {
            apple().validate();
        }
        if (azureStaticWebApps() != null) {
            azureStaticWebApps().validate();
        }
        if (customOpenIdConnectProviders() != null) {
            customOpenIdConnectProviders().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureActiveDirectory", this.azureActiveDirectory);
        jsonWriter.writeJsonField("facebook", this.facebook);
        jsonWriter.writeJsonField("gitHub", this.gitHub);
        jsonWriter.writeJsonField("google", this.google);
        jsonWriter.writeJsonField("twitter", this.twitter);
        jsonWriter.writeJsonField("apple", this.apple);
        jsonWriter.writeJsonField("azureStaticWebApps", this.azureStaticWebApps);
        jsonWriter.writeMapField("customOpenIdConnectProviders", this.customOpenIdConnectProviders,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IdentityProviders from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IdentityProviders if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IdentityProviders.
     */
    public static IdentityProviders fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IdentityProviders deserializedIdentityProviders = new IdentityProviders();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("azureActiveDirectory".equals(fieldName)) {
                    deserializedIdentityProviders.azureActiveDirectory = AzureActiveDirectory.fromJson(reader);
                } else if ("facebook".equals(fieldName)) {
                    deserializedIdentityProviders.facebook = Facebook.fromJson(reader);
                } else if ("gitHub".equals(fieldName)) {
                    deserializedIdentityProviders.gitHub = GitHub.fromJson(reader);
                } else if ("google".equals(fieldName)) {
                    deserializedIdentityProviders.google = Google.fromJson(reader);
                } else if ("twitter".equals(fieldName)) {
                    deserializedIdentityProviders.twitter = Twitter.fromJson(reader);
                } else if ("apple".equals(fieldName)) {
                    deserializedIdentityProviders.apple = Apple.fromJson(reader);
                } else if ("azureStaticWebApps".equals(fieldName)) {
                    deserializedIdentityProviders.azureStaticWebApps = AzureStaticWebApps.fromJson(reader);
                } else if ("customOpenIdConnectProviders".equals(fieldName)) {
                    Map<String, CustomOpenIdConnectProvider> customOpenIdConnectProviders
                        = reader.readMap(reader1 -> CustomOpenIdConnectProvider.fromJson(reader1));
                    deserializedIdentityProviders.customOpenIdConnectProviders = customOpenIdConnectProviders;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIdentityProviders;
        });
    }
}
