// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Use to select the lifecycle stages of a Container App during which the Managed Identity should be available.
 */
public final class IdentitySettingsLifeCycle extends ExpandableStringEnum<IdentitySettingsLifeCycle> {
    /**
     * Static value Init for IdentitySettingsLifeCycle.
     */
    public static final IdentitySettingsLifeCycle INIT = fromString("Init");

    /**
     * Static value Main for IdentitySettingsLifeCycle.
     */
    public static final IdentitySettingsLifeCycle MAIN = fromString("Main");

    /**
     * Static value None for IdentitySettingsLifeCycle.
     */
    public static final IdentitySettingsLifeCycle NONE = fromString("None");

    /**
     * Static value All for IdentitySettingsLifeCycle.
     */
    public static final IdentitySettingsLifeCycle ALL = fromString("All");

    /**
     * Creates a new instance of IdentitySettingsLifeCycle value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IdentitySettingsLifeCycle() {
    }

    /**
     * Creates or finds a IdentitySettingsLifeCycle from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IdentitySettingsLifeCycle.
     */
    public static IdentitySettingsLifeCycle fromString(String name) {
        return fromString(name, IdentitySettingsLifeCycle.class);
    }

    /**
     * Gets known IdentitySettingsLifeCycle values.
     * 
     * @return known IdentitySettingsLifeCycle values.
     */
    public static Collection<IdentitySettingsLifeCycle> values() {
        return values(IdentitySettingsLifeCycle.class);
    }
}
