// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Whether an http app listens on http or https.
 */
public final class IngressTargetPortHttpScheme extends ExpandableStringEnum<IngressTargetPortHttpScheme> {
    /**
     * Static value http for IngressTargetPortHttpScheme.
     */
    public static final IngressTargetPortHttpScheme HTTP = fromString("http");

    /**
     * Static value https for IngressTargetPortHttpScheme.
     */
    public static final IngressTargetPortHttpScheme HTTPS = fromString("https");

    /**
     * Creates a new instance of IngressTargetPortHttpScheme value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IngressTargetPortHttpScheme() {
    }

    /**
     * Creates or finds a IngressTargetPortHttpScheme from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IngressTargetPortHttpScheme.
     */
    public static IngressTargetPortHttpScheme fromString(String name) {
        return fromString(name, IngressTargetPortHttpScheme.class);
    }

    /**
     * Gets known IngressTargetPortHttpScheme values.
     * 
     * @return known IngressTargetPortHttpScheme values.
     */
    public static Collection<IngressTargetPortHttpScheme> values() {
        return values(IngressTargetPortHttpScheme.class);
    }
}
