// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Ingress transport protocol.
 */
public final class IngressTransportMethod extends ExpandableStringEnum<IngressTransportMethod> {
    /**
     * Static value auto for IngressTransportMethod.
     */
    public static final IngressTransportMethod AUTO = fromString("auto");

    /**
     * Static value http for IngressTransportMethod.
     */
    public static final IngressTransportMethod HTTP = fromString("http");

    /**
     * Static value http2 for IngressTransportMethod.
     */
    public static final IngressTransportMethod HTTP2 = fromString("http2");

    /**
     * Static value tcp for IngressTransportMethod.
     */
    public static final IngressTransportMethod TCP = fromString("tcp");

    /**
     * Creates a new instance of IngressTransportMethod value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IngressTransportMethod() {
    }

    /**
     * Creates or finds a IngressTransportMethod from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IngressTransportMethod.
     */
    public static IngressTransportMethod fromString(String name) {
        return fromString(name, IngressTransportMethod.class);
    }

    /**
     * Gets known IngressTransportMethod values.
     * 
     * @return known IngressTransportMethod values.
     */
    public static Collection<IngressTransportMethod> values() {
        return values(IngressTransportMethod.class);
    }
}
