// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.JavaComponentInner;

/**
 * An immutable client-side representation of JavaComponent.
 */
public interface JavaComponent {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the properties property: Java Component resource specific properties.
     * 
     * @return the properties value.
     */
    JavaComponentProperties properties();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.appcontainers.fluent.models.JavaComponentInner object.
     * 
     * @return the inner object.
     */
    JavaComponentInner innerModel();

    /**
     * The entirety of the JavaComponent definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The JavaComponent definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the JavaComponent definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the JavaComponent definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, environmentName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param environmentName Name of the Managed Environment.
             * @return the next definition stage.
             */
            WithCreate withExistingManagedEnvironment(String resourceGroupName, String environmentName);
        }

        /**
         * The stage of the JavaComponent definition which contains all the minimum required properties for the resource
         * to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithProperties {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            JavaComponent create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            JavaComponent create(Context context);
        }

        /**
         * The stage of the JavaComponent definition allowing to specify properties.
         */
        interface WithProperties {
            /**
             * Specifies the properties property: Java Component resource specific properties.
             * 
             * @param properties Java Component resource specific properties.
             * @return the next definition stage.
             */
            WithCreate withProperties(JavaComponentProperties properties);
        }
    }

    /**
     * Begins update for the JavaComponent resource.
     * 
     * @return the stage of resource update.
     */
    JavaComponent.Update update();

    /**
     * The template for JavaComponent update.
     */
    interface Update extends UpdateStages.WithProperties {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        JavaComponent apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        JavaComponent apply(Context context);
    }

    /**
     * The JavaComponent update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the JavaComponent update allowing to specify properties.
         */
        interface WithProperties {
            /**
             * Specifies the properties property: Java Component resource specific properties.
             * 
             * @param properties Java Component resource specific properties.
             * @return the next definition stage.
             */
            Update withProperties(JavaComponentProperties properties);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    JavaComponent refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    JavaComponent refresh(Context context);
}
